/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc4;

import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import edu.stanford.CVC4.Expr;
import edu.stanford.CVC4.ExprManager;
import edu.stanford.CVC4.ExprManagerMapCollection;
import edu.stanford.CVC4.Result;
import edu.stanford.CVC4.SExpr;
import edu.stanford.CVC4.SmtEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Evaluator;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.basicimpl.AbstractProverWithAllSat;
import org.sosy_lab.java_smt.basicimpl.ShutdownHook;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4Evaluator;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4FormulaCreator;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4Model;

class CVC4TheoremProver
extends AbstractProverWithAllSat<Void>
implements ProverEnvironment,
BasicProverEnvironment<Void> {
    private final CVC4FormulaCreator creator;
    SmtEngine smtEngine;
    private boolean changedSinceLastSatQuery = false;
    private final ExprManager exprManager = new ExprManager();
    private final ExprManagerMapCollection exportMapping = new ExprManagerMapCollection();
    private final boolean incremental;

    protected CVC4TheoremProver(CVC4FormulaCreator pFormulaCreator, ShutdownNotifier pShutdownNotifier, int randomSeed, Set<SolverContext.ProverOptions> pOptions, BooleanFormulaManager pBmgr) {
        super(pOptions, pBmgr, pShutdownNotifier);
        this.creator = pFormulaCreator;
        this.smtEngine = new SmtEngine(this.exprManager);
        this.incremental = !this.enableSL;
        this.setOptions(randomSeed, pOptions);
    }

    private void setOptions(int randomSeed, Set<SolverContext.ProverOptions> pOptions) {
        this.smtEngine.setOption("incremental", new SExpr(this.incremental));
        if (pOptions.contains((Object)SolverContext.ProverOptions.GENERATE_MODELS)) {
            this.smtEngine.setOption("produce-models", new SExpr(true));
        }
        if (pOptions.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE)) {
            this.smtEngine.setOption("produce-unsat-cores", new SExpr(true));
        }
        this.smtEngine.setOption("produce-assertions", new SExpr(true));
        this.smtEngine.setOption("dump-models", new SExpr(true));
        this.smtEngine.setOption("output-language", new SExpr("smt2"));
        this.smtEngine.setOption("random-seed", new SExpr(randomSeed));
        this.smtEngine.setOption("strings-exp", new SExpr(true));
        this.smtEngine.setOption("full-saturate-quant", new SExpr(true));
    }

    protected void setOptionForIncremental() {
        this.smtEngine.setOption("incremental", new SExpr(true));
    }

    protected Expr importExpr(Expr expr) {
        return expr.exportTo(this.exprManager, this.exportMapping);
    }

    protected Expr exportExpr(Expr expr) {
        return expr.exportTo((ExprManager)this.creator.getEnv(), this.exportMapping);
    }

    @Override
    protected void pushImpl() throws InterruptedException {
        this.setChanged();
        if (this.incremental) {
            this.smtEngine.push();
        }
    }

    @Override
    protected void popImpl() {
        this.setChanged();
        if (this.incremental) {
            this.smtEngine.pop();
        }
    }

    @Override
    protected @Nullable Void addConstraintImpl(BooleanFormula pF) throws InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.setChanged();
        Expr exp = this.creator.extractInfo(pF);
        if (this.incremental) {
            this.smtEngine.assertFormula(this.importExpr(exp));
        }
        return null;
    }

    @Override
    public CVC4Model getModel() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((!this.changedSinceLastSatQuery ? 1 : 0) != 0);
        this.checkGenerateModels();
        return this.registerEvaluator(new CVC4Model(this, this.creator, this.smtEngine, Collections2.transform(this.getAssertedFormulas(), this.creator::extractInfo)));
    }

    @Override
    public Evaluator getEvaluator() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkGenerateModels();
        return this.getEvaluatorWithoutChecks();
    }

    @Override
    protected Evaluator getEvaluatorWithoutChecks() {
        return this.registerEvaluator(new CVC4Evaluator(this, this.creator, this.smtEngine));
    }

    private void setChanged() {
        this.closeAllEvaluators();
        if (!this.changedSinceLastSatQuery) {
            this.changedSinceLastSatQuery = true;
            if (!this.incremental) {
                this.smtEngine = new SmtEngine(this.exprManager);
            }
        }
    }

    @Override
    public ImmutableList<Model.ValueAssignment> getModelAssignments() throws SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((!this.changedSinceLastSatQuery ? 1 : 0) != 0);
        return super.getModelAssignments();
    }

    @Override
    public boolean isUnsat() throws InterruptedException, SolverException {
        Result result;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.closeAllEvaluators();
        this.changedSinceLastSatQuery = false;
        if (!this.incremental) {
            this.getAssertedFormulas().forEach(f -> this.smtEngine.assertFormula(this.creator.extractInfo((Formula)f)));
        }
        try (ShutdownHook hook = new ShutdownHook(this.shutdownNotifier, () -> ((SmtEngine)this.smtEngine).interrupt());){
            this.shutdownNotifier.shutdownIfNecessary();
            result = this.smtEngine.checkSat();
        }
        this.shutdownNotifier.shutdownIfNecessary();
        return this.convertSatResult(result);
    }

    private boolean convertSatResult(Result result) throws InterruptedException, SolverException {
        if (result.isUnknown()) {
            if (result.whyUnknown().equals(Result.UnknownExplanation.INTERRUPTED)) {
                throw new InterruptedException();
            }
            throw new SolverException("CVC4 returned null or unknown on sat check (" + result + ")");
        }
        if (result.isSat() == Result.Sat.SAT) {
            return false;
        }
        if (result.isSat() == Result.Sat.UNSAT) {
            return true;
        }
        throw new SolverException("CVC4 returned unknown on sat check");
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkGenerateUnsatCores();
        Preconditions.checkState((!this.changedSinceLastSatQuery ? 1 : 0) != 0);
        ArrayList<BooleanFormula> converted = new ArrayList<BooleanFormula>();
        for (Expr aCore : this.smtEngine.getUnsatCore()) {
            converted.add(this.creator.encapsulateBoolean(this.exportExpr(aCore)));
        }
        return converted;
    }

    @Override
    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.exportMapping.delete();
            this.exprManager.delete();
        }
        super.close();
    }
}

