/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.mathsat5;

import java.math.BigInteger;
import java.util.function.Function;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.basicimpl.AbstractBitvectorFormulaManager;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5BooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5NativeApi;

class Mathsat5BitvectorFormulaManager
extends AbstractBitvectorFormulaManager<Long, Long, Long, Long> {
    private final long mathsatEnv;

    protected Mathsat5BitvectorFormulaManager(Mathsat5FormulaCreator pCreator, Mathsat5BooleanFormulaManager pBmgr) {
        super(pCreator, pBmgr);
        this.mathsatEnv = (Long)pCreator.getEnv();
    }

    @Override
    public Long concat(Long pFirst, Long pSecond) {
        return Mathsat5NativeApi.msat_make_bv_concat(this.mathsatEnv, pFirst, pSecond);
    }

    @Override
    public Long extract(Long pFirst, int pMsb, int pLsb) {
        return Mathsat5NativeApi.msat_make_bv_extract(this.mathsatEnv, pMsb, pLsb, pFirst);
    }

    @Override
    public Long extend(Long pNumber, int pExtensionBits, boolean pSigned) {
        if (pSigned) {
            return Mathsat5NativeApi.msat_make_bv_sext(this.mathsatEnv, pExtensionBits, pNumber);
        }
        return Mathsat5NativeApi.msat_make_bv_zext(this.mathsatEnv, pExtensionBits, pNumber);
    }

    @Override
    public Long makeBitvectorImpl(int pLength, long pI) {
        int i = (int)pI;
        if ((long)i == pI && i > 0) {
            return Mathsat5NativeApi.msat_make_bv_int_number(this.mathsatEnv, i, pLength);
        }
        return this.makeBitvectorImpl(pLength, BigInteger.valueOf(pI));
    }

    @Override
    public Long makeBitvectorImpl(int pLength, BigInteger pI) {
        pI = this.transformValueToRange(pLength, pI);
        return Mathsat5NativeApi.msat_make_bv_number(this.mathsatEnv, pI.toString(), pLength, 10);
    }

    @Override
    protected Long makeBitvectorImpl(int pLength, Long pIntegerFormula) {
        return Mathsat5NativeApi.msat_make_int_to_bv(this.mathsatEnv, pLength, pIntegerFormula);
    }

    @Override
    protected Long toIntegerFormulaImpl(Long pBVFormula, boolean pSigned) {
        if (pSigned) {
            return Mathsat5NativeApi.msat_make_int_from_sbv(this.mathsatEnv, pBVFormula);
        }
        return Mathsat5NativeApi.msat_make_int_from_ubv(this.mathsatEnv, pBVFormula);
    }

    @Override
    public Long makeVariableImpl(int length, String var) {
        long bvType = (Long)this.getFormulaCreator().getBitvectorType(length);
        return (Long)this.getFormulaCreator().makeVariable(bvType, var);
    }

    @Override
    public Long shiftRight(Long number, Long toShift, boolean signed) {
        long t = signed ? Mathsat5NativeApi.msat_make_bv_ashr(this.mathsatEnv, number, toShift) : Mathsat5NativeApi.msat_make_bv_lshr(this.mathsatEnv, number, toShift);
        return t;
    }

    @Override
    public Long shiftLeft(Long number, Long toShift) {
        return Mathsat5NativeApi.msat_make_bv_lshl(this.mathsatEnv, number, toShift);
    }

    @Override
    public Long rotateLeftByConstant(Long number, int toRotate) {
        return Mathsat5NativeApi.msat_make_bv_rol(this.mathsatEnv, toRotate, number);
    }

    @Override
    public Long rotateRightByConstant(Long number, int toRotate) {
        return Mathsat5NativeApi.msat_make_bv_ror(this.mathsatEnv, toRotate, number);
    }

    @Override
    public Long not(Long pBits) {
        return Mathsat5NativeApi.msat_make_bv_not(this.mathsatEnv, pBits);
    }

    @Override
    public Long and(Long pBits1, Long pBits2) {
        return Mathsat5NativeApi.msat_make_bv_and(this.mathsatEnv, pBits1, pBits2);
    }

    @Override
    public Long or(Long pBits1, Long pBits2) {
        return Mathsat5NativeApi.msat_make_bv_or(this.mathsatEnv, pBits1, pBits2);
    }

    @Override
    public Long xor(Long pBits1, Long pBits2) {
        return Mathsat5NativeApi.msat_make_bv_xor(this.mathsatEnv, pBits1, pBits2);
    }

    @Override
    public Long negate(Long pNumber) {
        return Mathsat5NativeApi.msat_make_bv_neg(this.mathsatEnv, pNumber);
    }

    @Override
    public Long add(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_bv_plus(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    public Long subtract(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_bv_minus(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    public Long divide(Long pNumber1, Long pNumber2, boolean signed) {
        if (signed) {
            return Mathsat5NativeApi.msat_make_bv_sdiv(this.mathsatEnv, pNumber1, pNumber2);
        }
        return Mathsat5NativeApi.msat_make_bv_udiv(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    public Long remainder(Long pNumber1, Long pNumber2, boolean signed) {
        if (signed) {
            return Mathsat5NativeApi.msat_make_bv_srem(this.mathsatEnv, pNumber1, pNumber2);
        }
        return Mathsat5NativeApi.msat_make_bv_urem(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    public Long smodulo(Long s, Long t) {
        int size = ((FormulaType.BitvectorType)this.formulaCreator.getFormulaType(s)).getSize();
        long zero = this.makeBitvectorImpl(size, 0L);
        Function<Long, Long> isNegative = term -> Mathsat5NativeApi.msat_make_bv_slt(this.mathsatEnv, term, zero);
        long sameSign = Mathsat5NativeApi.msat_make_iff(this.mathsatEnv, isNegative.apply(s), isNegative.apply(t));
        long srem = Mathsat5NativeApi.msat_make_bv_srem(this.mathsatEnv, s, t);
        long sremPlusT = Mathsat5NativeApi.msat_make_bv_plus(this.mathsatEnv, srem, t);
        return Mathsat5NativeApi.msat_make_term_ite(this.mathsatEnv, this.equal(t, zero), s, Mathsat5NativeApi.msat_make_term_ite(this.mathsatEnv, this.equal(srem, zero), zero, Mathsat5NativeApi.msat_make_term_ite(this.mathsatEnv, sameSign, srem, sremPlusT)));
    }

    @Override
    public Long multiply(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_bv_times(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    public Long equal(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_equal(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    public Long lessThan(Long pNumber1, Long pNumber2, boolean signed) {
        if (signed) {
            return Mathsat5NativeApi.msat_make_bv_slt(this.mathsatEnv, pNumber1, pNumber2);
        }
        return Mathsat5NativeApi.msat_make_bv_ult(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    public Long lessOrEquals(Long pNumber1, Long pNumber2, boolean signed) {
        if (signed) {
            return Mathsat5NativeApi.msat_make_bv_sleq(this.mathsatEnv, pNumber1, pNumber2);
        }
        return Mathsat5NativeApi.msat_make_bv_uleq(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    public Long greaterThan(Long pNumber1, Long pNumber2, boolean signed) {
        return this.lessThan(pNumber2, pNumber1, signed);
    }

    @Override
    public Long greaterOrEquals(Long pNumber1, Long pNumber2, boolean signed) {
        return this.lessOrEquals(pNumber2, pNumber1, signed);
    }
}

