/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.utils;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.visitors.DefaultFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;

public class PrettyPrinter {
    private final FormulaManager fmgr;

    public PrettyPrinter(FormulaManager pFmgr) {
        this.fmgr = pFmgr;
    }

    public String formulaToString(Formula f, PrinterOption ... options) {
        StringBuilder str = new StringBuilder();
        this.fmgr.visit(f, new PrettyPrintVisitor(this.fmgr, str, (Collection<PrinterOption>)ImmutableSet.copyOf((Object[])options)));
        return str.toString();
    }

    public String formulaToDot(Formula f, PrinterOption ... options) {
        DotVisitor plotter = new DotVisitor((Collection<PrinterOption>)ImmutableSet.copyOf((Object[])options));
        this.fmgr.visitRecursively(f, plotter);
        return plotter.toString();
    }

    private static boolean isBooleanFunction(FunctionDeclarationKind kind) {
        switch (kind) {
            case AND: 
            case OR: 
            case NOT: 
            case ITE: 
            case IFF: 
            case XOR: 
            case IMPLIES: {
                return true;
            }
        }
        return false;
    }

    private static String getColor(FunctionDeclarationKind kind) {
        switch (kind) {
            case AND: {
                return "lightblue";
            }
            case OR: {
                return "lightgreen";
            }
            case NOT: {
                return "orange";
            }
            case ITE: {
                return "yellow";
            }
            case IFF: 
            case XOR: 
            case IMPLIES: {
                return "lightpink";
            }
        }
        return "white";
    }

    private static String getEdgeLabel(FunctionDeclarationKind kind, int operandId) {
        switch (kind) {
            case AND: 
            case OR: 
            case NOT: 
            case IFF: 
            case XOR: {
                return "";
            }
        }
        return Integer.toString(operandId);
    }

    private static class DotVisitor
    extends DefaultFormulaVisitor<TraversalProcess> {
        private final Map<Formula, Integer> nodeMapping = new LinkedHashMap<Formula, Integer>();
        private final UniqueIdGenerator id = new UniqueIdGenerator();
        private final boolean onlyBooleanOperations;
        private final StringBuilder out = new StringBuilder("digraph SMT {" + System.lineSeparator() + "  rankdir=LR" + System.lineSeparator());
        private final List<String> leaves = new ArrayList<String>();

        private DotVisitor(Collection<PrinterOption> pOptions) {
            this.onlyBooleanOperations = pOptions.contains((Object)PrinterOption.SPLIT_ONLY_BOOLEAN_OPERATIONS);
        }

        public String toString() {
            if (!this.leaves.isEmpty()) {
                this.out.append("  { rank=same;").append(System.lineSeparator());
                this.leaves.forEach(this.out::append);
                this.out.append("  }").append(System.lineSeparator());
            }
            this.out.append("}");
            return this.out.toString();
        }

        private int getId(Formula f) {
            return this.nodeMapping.computeIfAbsent(f, unused -> this.id.getFreshId());
        }

        private String formatNode(Formula f, String label) {
            return this.formatNode(f, label, "rectangle", "white");
        }

        private String formatNode(Formula f, String label, String shape, String color) {
            return String.format("  %d [label=\"%s\", shape=\"%s\", style=\"filled\", fillcolor=\"%s\"];%n", this.getId(f), label, shape, color);
        }

        private String formatEdge(Formula from, Formula to, String label) {
            return String.format("  %d -> %d [label=\"%s\"];%n", this.getId(from), this.getId(to), label);
        }

        @Override
        protected TraversalProcess visitDefault(Formula pF) {
            this.out.append(this.formatNode(pF, pF.toString()));
            return TraversalProcess.CONTINUE;
        }

        @Override
        public TraversalProcess visitConstant(Formula pF, Object value) {
            this.out.append(this.formatNode(pF, pF.toString(), "rectangle", "grey"));
            return TraversalProcess.CONTINUE;
        }

        @Override
        public TraversalProcess visitFunction(Formula pF, List<Formula> pArgs, FunctionDeclaration<?> pFunctionDeclaration) {
            FunctionDeclarationKind kind = pFunctionDeclaration.getKind();
            if (this.onlyBooleanOperations && !PrettyPrinter.isBooleanFunction(kind)) {
                this.leaves.add("  " + this.formatNode(pF, pF.toString()));
                return TraversalProcess.SKIP;
            }
            String color = PrettyPrinter.getColor(kind);
            this.out.append(this.formatNode(pF, pFunctionDeclaration.getName(), "circle", color));
            int operandId = 0;
            for (Formula arg : pArgs) {
                this.out.append(this.formatEdge(pF, arg, PrettyPrinter.getEdgeLabel(kind, operandId++)));
            }
            return TraversalProcess.CONTINUE;
        }
    }

    private static class PrettyPrintVisitor
    extends DefaultFormulaVisitor<Void> {
        private final FormulaManager fmgr;
        private final StringBuilder out;
        private final boolean onlyBooleanOperations;
        private int depth = 0;
        private boolean enableSplitting = true;

        private PrettyPrintVisitor(FormulaManager pFmgr, StringBuilder pStr, Collection<PrinterOption> pOptions) {
            this.fmgr = pFmgr;
            this.out = pStr;
            this.onlyBooleanOperations = pOptions.contains((Object)PrinterOption.SPLIT_ONLY_BOOLEAN_OPERATIONS);
        }

        private void newline() {
            if (this.enableSplitting) {
                if (this.out.length() != 0) {
                    this.out.append(System.lineSeparator());
                }
                this.out.append("  ".repeat(this.depth));
            } else {
                this.out.append(" ");
            }
        }

        @Override
        protected Void visitDefault(Formula pF) {
            this.newline();
            this.out.append(pF);
            return null;
        }

        @Override
        public Void visitFunction(Formula pF, List<Formula> pArgs, FunctionDeclaration<?> pFunctionDeclaration) {
            this.newline();
            this.out.append("(").append(pFunctionDeclaration.getName());
            boolean splitNested = true;
            if (this.enableSplitting && this.onlyBooleanOperations && !PrettyPrinter.isBooleanFunction(pFunctionDeclaration.getKind())) {
                splitNested = false;
            }
            if (!splitNested) {
                this.enableSplitting = false;
            }
            ++this.depth;
            for (Formula arg : pArgs) {
                this.fmgr.visit(arg, this);
            }
            --this.depth;
            if (this.enableSplitting) {
                this.newline();
            }
            this.out.append(")");
            if (!splitNested) {
                this.enableSplitting = true;
            }
            return null;
        }
    }

    public static enum PrinterOption {
        SPLIT_ONLY_BOOLEAN_OPERATIONS;

    }
}

