/*
 * Decompiled with CFR 0.152.
 */
package org.sourcegrade.jagr.api.rubric;

import com.google.inject.Inject;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.sourcegrade.jagr.api.rubric.CriterionHolder;
import org.sourcegrade.jagr.api.rubric.CriterionHolderPointCalculator;
import org.sourcegrade.jagr.api.rubric.Gradable;
import org.sourcegrade.jagr.api.rubric.GradedCriterion;
import org.sourcegrade.jagr.api.rubric.Grader;
import org.sourcegrade.jagr.api.rubric.Rubric;

@ApiStatus.NonExtendable
public interface Criterion
extends Gradable<GradedCriterion>,
CriterionHolder<Criterion> {
    public static Builder builder() {
        return FactoryProvider.factory.builder();
    }

    public String getShortDescription();

    @Nullable
    public String getHiddenNotes();

    public boolean isTerminal();

    public Rubric getParentRubric();

    public CriterionHolder<? extends Criterion> getParent();

    @Nullable
    public Criterion getParentCriterion();

    public List<? extends Criterion> getPeers();

    @ApiStatus.Internal
    public static final class FactoryProvider {
        @Inject
        private static Factory factory;
    }

    @ApiStatus.Internal
    public static interface Factory {
        public Builder builder();
    }

    @ApiStatus.NonExtendable
    public static interface Builder {
        public Builder shortDescription(String var1);

        public Builder hiddenNotes(@Nullable String var1);

        public Builder grader(@Nullable Grader var1);

        default public Builder maxPoints(int maxPoints) {
            return this.maxPoints(CriterionHolderPointCalculator.fixed(maxPoints));
        }

        public Builder maxPoints(@Nullable CriterionHolderPointCalculator var1);

        default public Builder minPoints(int minPoints) {
            return this.minPoints(CriterionHolderPointCalculator.fixed(minPoints));
        }

        public Builder minPoints(@Nullable CriterionHolderPointCalculator var1);

        public Builder addChildCriteria(Criterion ... var1);

        public Criterion build();
    }
}

