/*
 * Decompiled with CFR 0.152.
 */
package org.sourcegrade.jagr.api.rubric;

import com.google.inject.Inject;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.ApiStatus;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestIdentifier;

@FunctionalInterface
public interface JUnitTestRef {
    public static JUnitTestRef ofClass(Class<?> clazz) {
        return FactoryProvider.factory.ofClass(clazz);
    }

    public static JUnitTestRef ofClass(Callable<Class<?>> clazzSupplier) {
        return FactoryProvider.factory.ofClass(clazzSupplier);
    }

    public static JUnitTestRef ofMethod(Method method) {
        return FactoryProvider.factory.ofMethod(method);
    }

    public static JUnitTestRef ofMethod(Callable<Method> methodSupplier) {
        return FactoryProvider.factory.ofMethod(methodSupplier);
    }

    public static JUnitTestRef and(JUnitTestRef ... testRefs) {
        return FactoryProvider.factory.and(testRefs);
    }

    public static JUnitTestRef or(JUnitTestRef ... testRefs) {
        return FactoryProvider.factory.or(testRefs);
    }

    public static JUnitTestRef not(JUnitTestRef testRef) {
        return FactoryProvider.factory.not(testRef);
    }

    public TestExecutionResult get(Map<TestIdentifier, TestExecutionResult> var1);

    @ApiStatus.Internal
    public static final class FactoryProvider {
        @Inject
        private static Factory factory;
    }

    @ApiStatus.Internal
    public static interface Factory {
        public JUnitTestRef ofClass(Class<?> var1);

        public JUnitTestRef ofClass(Callable<Class<?>> var1);

        public JUnitTestRef ofMethod(Method var1);

        public JUnitTestRef ofMethod(Callable<Method> var1);

        public JUnitTestRef and(JUnitTestRef ... var1);

        public JUnitTestRef or(JUnitTestRef ... var1);

        public JUnitTestRef not(JUnitTestRef var1);
    }
}

