/*
 * Decompiled with CFR 0.152.
 */
package org.sourcegrade.jagr.launcher.executor;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sourcegrade.jagr.api.rubric.GradedRubric;
import org.sourcegrade.jagr.api.testing.Submission;
import org.sourcegrade.jagr.launcher.env.Jagr;
import org.sourcegrade.jagr.launcher.env.JagrKt;
import org.sourcegrade.jagr.launcher.executor.GradingJob;
import org.sourcegrade.jagr.launcher.executor.GradingRequest;
import org.sourcegrade.jagr.launcher.executor.GradingResult;
import org.sourcegrade.jagr.launcher.executor.RuntimeGrader;
import org.sourcegrade.jagr.launcher.io.GraderJar;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a6\u0010\u0000\u001a\u00020\u0001*\u00020\u00022*\u0010\u0003\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0004\u001a*\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0016\b\u0002\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011\u001a@\u0010\u000b\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2*\u0010\u0003\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0004\u00a8\u0006\u0012"}, d2={"grade", "Lorg/sourcegrade/jagr/launcher/executor/GradingResult;", "Lorg/sourcegrade/jagr/launcher/executor/GradingRequest;", "gradingFun", "Lkotlin/Function2;", "", "Lorg/sourcegrade/jagr/launcher/io/GraderJar;", "Lorg/sourcegrade/jagr/api/testing/Submission;", "", "Lorg/sourcegrade/jagr/api/rubric/GradedRubric;", "", "gradeCatching", "", "Lorg/sourcegrade/jagr/launcher/executor/GradingJob;", "jagr", "Lorg/sourcegrade/jagr/launcher/env/Jagr;", "primaryGrader", "Lkotlin/Function1;", "jagr-launcher"})
public final class RuntimeGraderKt {
    @NotNull
    public static final GradingResult grade(@NotNull GradingRequest $this$grade, @NotNull Function2<? super List<? extends GraderJar>, ? super Submission, ? extends Map<GradedRubric, String>> gradingFun) {
        Intrinsics.checkNotNullParameter((Object)$this$grade, (String)"<this>");
        Intrinsics.checkNotNullParameter(gradingFun, (String)"gradingFun");
        Instant startedUtc = OffsetDateTime.now(ZoneOffset.UTC).toInstant();
        Map rubrics = (Map)gradingFun.invoke($this$grade.getGraders(), (Object)$this$grade.getSubmission());
        Instant finishedUtc = OffsetDateTime.now(ZoneOffset.UTC).toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)startedUtc, (String)"startedUtc");
        Intrinsics.checkNotNullExpressionValue((Object)finishedUtc, (String)"finishedUtc");
        return new GradingResult(startedUtc, finishedUtc, $this$grade, rubrics);
    }

    @Nullable
    public static final GradingResult gradeCatching(@NotNull GradingRequest $this$gradeCatching, @NotNull Jagr jagr, @NotNull Function2<? super List<? extends GraderJar>, ? super Submission, ? extends Map<GradedRubric, String>> gradingFun) {
        GradingResult gradingResult2;
        Intrinsics.checkNotNullParameter((Object)$this$gradeCatching, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)jagr, (String)"jagr");
        Intrinsics.checkNotNullParameter(gradingFun, (String)"gradingFun");
        try {
            gradingResult2 = RuntimeGraderKt.grade($this$gradeCatching, gradingFun);
        }
        catch (Throwable e) {
            JagrKt.getLogger(jagr).error("A fatal error occurred grading " + $this$gradeCatching.getSubmission().getInfo() + " :: " + Reflection.getOrCreateKotlinClass(e.getClass()).getSimpleName() + " " + e.getMessage(), e);
            gradingResult2 = null;
        }
        return gradingResult2;
    }

    public static final void gradeCatching(@NotNull GradingJob $this$gradeCatching, @NotNull Jagr jagr, @NotNull Function1<? super GradingRequest, GradingResult> primaryGrader) {
        Intrinsics.checkNotNullParameter((Object)$this$gradeCatching, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)jagr, (String)"jagr");
        Intrinsics.checkNotNullParameter(primaryGrader, (String)"primaryGrader");
        try {
            GradingResult gradingResult2 = (GradingResult)primaryGrader.invoke((Object)$this$gradeCatching.getRequest());
            GradingResult gradingResult3 = gradingResult2 == null ? RuntimeGraderKt.grade($this$gradeCatching.getRequest(), (Function2<? super List<? extends GraderJar>, ? super Submission, ? extends Map<GradedRubric, String>>)((Function2)new Function2<List<? extends GraderJar>, Submission, Map<GradedRubric, ? extends String>>((Object)JagrKt.getRuntimeGrader(jagr)){

                @NotNull
                public final Map<GradedRubric, String> invoke(@NotNull List<? extends GraderJar> p0, @NotNull Submission p1) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return ((RuntimeGrader)this.receiver).gradeFallback(p0, p1);
                }
            })) : gradingResult2;
            $this$gradeCatching.getResult().complete((Object)gradingResult3);
        }
        catch (Throwable e) {
            StackTraceElement causeSTE;
            Object object;
            block3: {
                StackTraceElement[] stackTraceElementArray = e.getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"e.stackTrace");
                Object[] $this$firstOrNull$iv = stackTraceElementArray;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    StackTraceElement it = (StackTraceElement)element$iv;
                    boolean bl = false;
                    String string = it.getClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.className");
                    if (!(!StringsKt.startsWith$default((String)string, (String)"java", (boolean)false, (int)2, null))) continue;
                    object = element$iv;
                    break block3;
                }
                object = null;
            }
            StackTraceElement stackTraceElement = causeSTE = (StackTraceElement)object;
            String causeClass = stackTraceElement == null ? null : stackTraceElement.getClassName();
            IllegalStateException exception = new IllegalStateException("\nA fatal error occurred in the fallback grader for submission " + $this$gradeCatching.getRequest().getSubmission().getInfo() + " :: " + Reflection.getOrCreateKotlinClass(e.getClass()).getSimpleName() + " " + e.getMessage() + "\nThis is not an error in the submission, rather in the RuntimeGrader implementation @ " + causeSTE + ".\nPlease report this to the maintainers of " + causeClass + ".\n", e);
            $this$gradeCatching.getResult().completeExceptionally((Throwable)exception);
        }
    }

    public static /* synthetic */ void gradeCatching$default(GradingJob gradingJob, Jagr jagr, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = (Function1)new Function1<GradingRequest, GradingResult>(gradingJob, jagr){
                final /* synthetic */ GradingJob $this_gradeCatching;
                final /* synthetic */ Jagr $jagr;
                {
                    this.$this_gradeCatching = $receiver;
                    this.$jagr = $jagr;
                    super(1);
                }

                @Nullable
                public final GradingResult invoke(@NotNull GradingRequest it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return RuntimeGraderKt.gradeCatching(this.$this_gradeCatching.getRequest(), this.$jagr, (Function2<? super List<? extends GraderJar>, ? super Submission, ? extends Map<GradedRubric, String>>)((Function2)new Function2<List<? extends GraderJar>, Submission, Map<GradedRubric, ? extends String>>((Object)JagrKt.getRuntimeGrader(this.$jagr)){

                        @NotNull
                        public final Map<GradedRubric, String> invoke(@NotNull List<? extends GraderJar> p0, @NotNull Submission p1) {
                            Intrinsics.checkNotNullParameter(p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            return ((RuntimeGrader)this.receiver).grade(p0, p1);
                        }
                    }));
                }
            };
        }
        RuntimeGraderKt.gradeCatching(gradingJob, jagr, (Function1<? super GradingRequest, GradingResult>)function1);
    }
}

