/*
 * Decompiled with CFR 0.152.
 */
package org.sourcegrade.jagr.launcher.executor;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sourcegrade.jagr.api.testing.Submission;
import org.sourcegrade.jagr.launcher.executor.GradingQueue;
import org.sourcegrade.jagr.launcher.executor.GradingRequest;
import org.sourcegrade.jagr.launcher.io.GraderJar;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\bR\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\rR\u0014\u0010\u0017\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001f"}, d2={"Lorg/sourcegrade/jagr/launcher/executor/SingletonGradingQueue;", "Lorg/sourcegrade/jagr/launcher/executor/GradingQueue;", "job", "Lorg/sourcegrade/jagr/launcher/executor/GradingRequest;", "(Lorg/sourcegrade/jagr/launcher/executor/GradingRequest;)V", "finishedUtc", "Ljava/time/Instant;", "getFinishedUtc", "()Ljava/time/Instant;", "graders", "", "Lorg/sourcegrade/jagr/launcher/io/GraderJar;", "getGraders", "()Ljava/util/List;", "remaining", "", "getRemaining", "()I", "startedUtc", "getStartedUtc", "submissions", "Lorg/sourcegrade/jagr/api/testing/Submission;", "getSubmissions", "total", "getTotal", "wasRead", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getWasRead", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "next", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "jagr-launcher"})
final class SingletonGradingQueue
implements GradingQueue {
    @NotNull
    private final GradingRequest job;
    @NotNull
    private final List<GraderJar> graders;
    @NotNull
    private final List<Submission> submissions;
    private final int total;
    @NotNull
    private final Instant startedUtc;
    @Nullable
    private final Instant finishedUtc;
    @NotNull
    private final AtomicBoolean wasRead;

    public SingletonGradingQueue(@NotNull GradingRequest job) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        this.job = job;
        this.graders = this.job.getGraders();
        this.submissions = CollectionsKt.listOf((Object)this.job.getSubmission());
        this.total = 1;
        Instant instant = OffsetDateTime.now(ZoneOffset.UTC).toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(ZoneOffset.UTC).toInstant()");
        this.startedUtc = instant;
        this.wasRead = new AtomicBoolean();
    }

    @Override
    @NotNull
    public List<GraderJar> getGraders() {
        return this.graders;
    }

    @Override
    @NotNull
    public List<Submission> getSubmissions() {
        return this.submissions;
    }

    @Override
    public int getTotal() {
        return this.total;
    }

    @Override
    public int getRemaining() {
        return this.wasRead.get() ? 0 : 1;
    }

    @Override
    @NotNull
    public Instant getStartedUtc() {
        return this.startedUtc;
    }

    @Override
    @Nullable
    public Instant getFinishedUtc() {
        return this.finishedUtc;
    }

    @NotNull
    public final AtomicBoolean getWasRead() {
        return this.wasRead;
    }

    @Override
    @Nullable
    public Object next(@NotNull Continuation<? super GradingRequest> $completion) {
        if (this.getWasRead().get()) {
            return null;
        }
        this.getWasRead().set(true);
        return this.job;
    }
}

