/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourcelab.buildkite.api.client.Configuration;
import org.sourcelab.buildkite.api.client.exception.BuildkiteException;
import org.sourcelab.buildkite.api.client.exception.InvalidAccessTokenException;
import org.sourcelab.buildkite.api.client.exception.InvalidAllowedIpAddressException;
import org.sourcelab.buildkite.api.client.exception.InvalidPagingRequestException;
import org.sourcelab.buildkite.api.client.exception.InvalidRequestException;
import org.sourcelab.buildkite.api.client.exception.NotFoundException;
import org.sourcelab.buildkite.api.client.http.Client;
import org.sourcelab.buildkite.api.client.http.HttpResult;
import org.sourcelab.buildkite.api.client.request.BuildFilters;
import org.sourcelab.buildkite.api.client.request.BuildFiltersBuilder;
import org.sourcelab.buildkite.api.client.request.CancelBuildRequest;
import org.sourcelab.buildkite.api.client.request.CreateBuildOptions;
import org.sourcelab.buildkite.api.client.request.CreateBuildOptionsBuilder;
import org.sourcelab.buildkite.api.client.request.CreateBuildRequest;
import org.sourcelab.buildkite.api.client.request.DeleteAccessTokenRequest;
import org.sourcelab.buildkite.api.client.request.GetAccessTokenRequest;
import org.sourcelab.buildkite.api.client.request.GetBuildFilters;
import org.sourcelab.buildkite.api.client.request.GetBuildFiltersBuilder;
import org.sourcelab.buildkite.api.client.request.GetBuildRequest;
import org.sourcelab.buildkite.api.client.request.GetMetaRequest;
import org.sourcelab.buildkite.api.client.request.GetOrganizationRequest;
import org.sourcelab.buildkite.api.client.request.GetPipelineRequest;
import org.sourcelab.buildkite.api.client.request.GetUserRequest;
import org.sourcelab.buildkite.api.client.request.ListBuildsRequest;
import org.sourcelab.buildkite.api.client.request.ListEmojisRequest;
import org.sourcelab.buildkite.api.client.request.ListOrganizationsRequest;
import org.sourcelab.buildkite.api.client.request.ListPipelinesRequest;
import org.sourcelab.buildkite.api.client.request.OrganizationFilters;
import org.sourcelab.buildkite.api.client.request.OrganizationFiltersBuilder;
import org.sourcelab.buildkite.api.client.request.PageOptions;
import org.sourcelab.buildkite.api.client.request.PageableRequest;
import org.sourcelab.buildkite.api.client.request.PingRequest;
import org.sourcelab.buildkite.api.client.request.PipelineFilters;
import org.sourcelab.buildkite.api.client.request.PipelineFiltersBuilder;
import org.sourcelab.buildkite.api.client.request.RebuildBuildRequest;
import org.sourcelab.buildkite.api.client.request.Request;
import org.sourcelab.buildkite.api.client.request.RetryJobOptions;
import org.sourcelab.buildkite.api.client.request.RetryJobOptionsBuilder;
import org.sourcelab.buildkite.api.client.request.RetryJobRequest;
import org.sourcelab.buildkite.api.client.request.UnblockJobOptions;
import org.sourcelab.buildkite.api.client.request.UnblockJobOptionsBuilder;
import org.sourcelab.buildkite.api.client.request.UnblockJobRequest;
import org.sourcelab.buildkite.api.client.response.AccessTokenResponse;
import org.sourcelab.buildkite.api.client.response.Build;
import org.sourcelab.buildkite.api.client.response.CurrentUserResponse;
import org.sourcelab.buildkite.api.client.response.Emoji;
import org.sourcelab.buildkite.api.client.response.ErrorResponse;
import org.sourcelab.buildkite.api.client.response.Job;
import org.sourcelab.buildkite.api.client.response.ListBuildsResponse;
import org.sourcelab.buildkite.api.client.response.ListOrganizationsResponse;
import org.sourcelab.buildkite.api.client.response.ListPipelinesResponse;
import org.sourcelab.buildkite.api.client.response.MetaResponse;
import org.sourcelab.buildkite.api.client.response.Organization;
import org.sourcelab.buildkite.api.client.response.PageableResponse;
import org.sourcelab.buildkite.api.client.response.PagingLinks;
import org.sourcelab.buildkite.api.client.response.PingResponse;
import org.sourcelab.buildkite.api.client.response.Pipeline;
import org.sourcelab.buildkite.api.client.response.parser.ErrorResponseParser;

public class BuildkiteClient {
    private static final Logger logger = LoggerFactory.getLogger(BuildkiteClient.class);
    private final Configuration configuration;
    private final Client httpClient;

    public BuildkiteClient(Configuration configuration) {
        this.configuration = configuration;
        this.httpClient = configuration.getClientFactory().createClient(configuration);
    }

    public PingResponse ping() throws BuildkiteException {
        return this.executeRequest(new PingRequest());
    }

    public AccessTokenResponse getAccessToken() throws BuildkiteException {
        return this.executeRequest(new GetAccessTokenRequest());
    }

    public boolean deleteAccessToken() throws BuildkiteException {
        return this.executeRequest(new DeleteAccessTokenRequest());
    }

    public CurrentUserResponse getUser() throws BuildkiteException {
        return this.executeRequest(new GetUserRequest());
    }

    public ListOrganizationsResponse listOrganizations() throws BuildkiteException {
        return this.listOrganizations(OrganizationFilters.newBuilder());
    }

    public ListOrganizationsResponse listOrganizations(OrganizationFiltersBuilder filters) throws BuildkiteException {
        Objects.requireNonNull(filters);
        return this.listOrganizations(filters.build());
    }

    public ListOrganizationsResponse listOrganizations(OrganizationFilters filters) throws BuildkiteException {
        Objects.requireNonNull(filters);
        return this.executeRequest(new ListOrganizationsRequest(filters));
    }

    public Optional<Organization> getOrganization(String organizationSlugId) throws BuildkiteException {
        Objects.requireNonNull(organizationSlugId);
        Organization response = this.executeRequest(new GetOrganizationRequest(organizationSlugId));
        return Optional.ofNullable(response);
    }

    public ListPipelinesResponse listPipelines(PipelineFiltersBuilder filters) throws BuildkiteException {
        Objects.requireNonNull(filters);
        return this.listPipelines(filters.build());
    }

    public ListPipelinesResponse listPipelines(PipelineFilters filters) throws BuildkiteException {
        Objects.requireNonNull(filters);
        return this.executeRequest(new ListPipelinesRequest(filters));
    }

    public ListPipelinesResponse listPipelines(String organizationSlugId) throws BuildkiteException {
        Objects.requireNonNull(organizationSlugId);
        return this.listPipelines(PipelineFilters.newBuilder().withOrganization(organizationSlugId));
    }

    public Optional<Pipeline> getPipeline(String organizationSlugId, String pipelineSlugId) throws BuildkiteException {
        Objects.requireNonNull(organizationSlugId);
        Objects.requireNonNull(pipelineSlugId);
        Pipeline pipeline = this.executeRequest(new GetPipelineRequest(organizationSlugId, pipelineSlugId));
        return Optional.ofNullable(pipeline);
    }

    public ListBuildsResponse listBuilds() {
        return this.listBuilds(BuildFilters.newBuilder().build());
    }

    public ListBuildsResponse listBuilds(BuildFiltersBuilder filtersBuilder) {
        return this.listBuilds(filtersBuilder.build());
    }

    public ListBuildsResponse listBuilds(BuildFilters filters) {
        return this.executeRequest(new ListBuildsRequest(filters));
    }

    public Optional<Build> getBuild(GetBuildFiltersBuilder filters) {
        return this.getBuild(filters.build());
    }

    public Optional<Build> getBuild(String organizationSlugId, String pipelineSlugId, long buildNumber) {
        return this.getBuild(GetBuildFilters.newBuilder().withOrgIdSlug(organizationSlugId).withPipelineIdSlug(pipelineSlugId).withBuildNumber(buildNumber));
    }

    public Optional<Build> getBuild(GetBuildFilters filters) {
        Build build = this.executeRequest(new GetBuildRequest(filters));
        return Optional.ofNullable(build);
    }

    public Build cancelBuild(String organizationSlugId, String pipelineSlugId, long buildNumber) {
        return this.executeRequest(new CancelBuildRequest(organizationSlugId, pipelineSlugId, buildNumber));
    }

    public Build createBuild(CreateBuildOptionsBuilder createBuildOptions) {
        return this.createBuild(createBuildOptions.build());
    }

    public Build createBuild(CreateBuildOptions createBuildOptions) {
        return this.executeRequest(new CreateBuildRequest(createBuildOptions));
    }

    public Build rebuildBuild(String organizationSlugId, String pipelineSlugId, long buildNumber) {
        return this.executeRequest(new RebuildBuildRequest(organizationSlugId, pipelineSlugId, buildNumber));
    }

    public Job retryJob(RetryJobOptionsBuilder options) {
        return this.retryJob(options.build());
    }

    public Job retryJob(RetryJobOptions options) {
        return this.executeRequest(new RetryJobRequest(options));
    }

    public Job unblockJob(UnblockJobOptionsBuilder options) {
        return this.unblockJob(options.build());
    }

    public Job unblockJob(UnblockJobOptions options) {
        return this.executeRequest(new UnblockJobRequest(options));
    }

    public List<Emoji> listEmojis(String orgIdSlug) {
        return this.executeRequest(new ListEmojisRequest(orgIdSlug));
    }

    public MetaResponse getMeta() throws BuildkiteException {
        return this.executeRequest(new GetMetaRequest());
    }

    public <T> T nextPage(PageableResponse<T> response) {
        PageOptions pageOptions;
        Objects.requireNonNull(response);
        PagingLinks pagingLinks = Objects.requireNonNull(response.getPagingLinks());
        if (!pagingLinks.hasNextUrl()) {
            throw new InvalidPagingRequestException("Requested 'Next' page on response " + response.getClass().getSimpleName() + ", but no Next page is available.");
        }
        try {
            pageOptions = PageOptions.fromUrl(pagingLinks.getNextUrl());
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidPagingRequestException("Unable to parse URL for paging information", ex);
        }
        PageableRequest<T> request = response.getOriginalRequest();
        request.updatePageOptions(pageOptions);
        return this.executeRequest(request);
    }

    public <T> T previousPage(PageableResponse<T> response) {
        PageOptions pageOptions;
        Objects.requireNonNull(response);
        PagingLinks pagingLinks = Objects.requireNonNull(response.getPagingLinks());
        if (!pagingLinks.hasPrevUrl()) {
            throw new InvalidPagingRequestException("Requested 'Previous' page on response " + response.getClass().getSimpleName() + ", but no Previous page is available.");
        }
        try {
            pageOptions = PageOptions.fromUrl(pagingLinks.getNextUrl());
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidPagingRequestException("Unable to parse URL for paging information", ex);
        }
        PageableRequest<T> request = response.getOriginalRequest();
        request.updatePageOptions(pageOptions);
        return this.executeRequest(request);
    }

    public <T> T firstPage(PageableResponse<T> response) {
        PageOptions pageOptions;
        Objects.requireNonNull(response);
        PagingLinks pagingLinks = Objects.requireNonNull(response.getPagingLinks());
        if (!pagingLinks.hasFirstUrl()) {
            throw new InvalidPagingRequestException("Requested 'First' page on response " + response.getClass().getSimpleName() + ", but no First page is available.");
        }
        try {
            pageOptions = PageOptions.fromUrl(pagingLinks.getNextUrl());
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidPagingRequestException("Unable to parse URL for paging information", ex);
        }
        PageableRequest<T> request = response.getOriginalRequest();
        request.updatePageOptions(pageOptions);
        return this.executeRequest(request);
    }

    public <T> T lastPage(PageableResponse<T> response) {
        PageOptions pageOptions;
        Objects.requireNonNull(response);
        PagingLinks pagingLinks = Objects.requireNonNull(response.getPagingLinks());
        if (!pagingLinks.hasLastUrl()) {
            throw new InvalidPagingRequestException("Requested 'Last' page on response " + response.getClass().getSimpleName() + ", but no Last page is available.");
        }
        try {
            pageOptions = PageOptions.fromUrl(pagingLinks.getNextUrl());
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidPagingRequestException("Unable to parse URL for paging information", ex);
        }
        PageableRequest<T> request = response.getOriginalRequest();
        request.updatePageOptions(pageOptions);
        return this.executeRequest(request);
    }

    public <T> T executeRequest(Request<T> request) throws BuildkiteException {
        HttpResult result = this.httpClient.executeRequest(request);
        logger.trace("HttpResult: {}", (Object)result);
        if (result.getStatus() != 200 && result.getStatus() != 201 && result.getStatus() != 204) {
            this.handleError(result);
        }
        return request.parseResponse(result);
    }

    private void handleError(HttpResult errorResult) throws BuildkiteException {
        String errorMessage = null;
        List<Object> errors = Collections.emptyList();
        try {
            ErrorResponse errorResponse = new ErrorResponseParser().parseResponse(errorResult);
            errorMessage = errorResponse.getMessage();
            errors = errorResponse.getErrors();
        }
        catch (IOException e) {
            errorMessage = errorResult.getContent();
        }
        if (errorMessage != null && errorMessage.trim().isEmpty()) {
            errorMessage = null;
        }
        switch (errorResult.getStatus()) {
            case 401: {
                throw new InvalidAccessTokenException(errorMessage == null ? "Invalid Access Token" : errorMessage);
            }
            case 403: {
                throw new InvalidAllowedIpAddressException(errorMessage == null ? "API requested from an IP address not specifically allowed by your AccessToken. Check the 'Allowed IP Addresses' field on your Access Token" : errorMessage);
            }
            case 404: {
                throw new NotFoundException(errorMessage == null ? "The URL or Resource Request could not be found" : errorMessage);
            }
            case 422: {
                String validationErrorMessage = errorMessage != null ? errorMessage : "The submitted request was invalid. ";
                validationErrorMessage = validationErrorMessage + "\n" + errors.stream().map(error -> error.getField() + ": " + error.getCode()).collect(Collectors.joining("\n"));
                throw new InvalidRequestException(validationErrorMessage, errors);
            }
        }
        throw new BuildkiteException(errorMessage == null ? "Unknown/Unhandled Error HttpCode: " + errorResult.getStatus() : errorMessage);
    }
}

