/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client;

import org.sourcelab.buildkite.api.client.Configuration;
import org.sourcelab.buildkite.api.client.exception.BuilderValidationException;
import org.sourcelab.buildkite.api.client.http.ClientFactory;
import org.sourcelab.buildkite.api.client.http.DefaultClientFactory;

public final class ConfigurationBuilder {
    private String apiToken = null;
    private String apiUrl = "https://api.buildkite.com";
    private ClientFactory clientFactory = new DefaultClientFactory();

    public ConfigurationBuilder withApiToken(String apiToken) {
        this.apiToken = apiToken;
        return this;
    }

    public ConfigurationBuilder withClientFactory(ClientFactory clientFactory) {
        this.clientFactory = clientFactory;
        return this;
    }

    private void validate() {
        if (this.apiToken == null || this.apiToken.trim().isEmpty()) {
            throw new BuilderValidationException("The 'ApiToken' property must be configured.");
        }
        if (this.clientFactory == null) {
            throw new BuilderValidationException("The 'ClientFactory' property must be configured.");
        }
        if (this.apiUrl == null || this.apiUrl.trim().isEmpty()) {
            throw new BuilderValidationException("The 'ApiUrl' property must be configured.");
        }
    }

    public Configuration build() {
        this.validate();
        return new Configuration(this.apiToken, this.apiUrl, this.clientFactory);
    }
}

