/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client.http;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.net.URIBuilder;
import org.sourcelab.buildkite.api.client.Configuration;
import org.sourcelab.buildkite.api.client.exception.HttpRequestException;
import org.sourcelab.buildkite.api.client.http.Client;
import org.sourcelab.buildkite.api.client.http.HttpHeader;
import org.sourcelab.buildkite.api.client.http.HttpHeaders;
import org.sourcelab.buildkite.api.client.http.HttpResult;
import org.sourcelab.buildkite.api.client.request.Request;
import org.sourcelab.buildkite.api.client.request.RequestParameter;

public class HttpComponentsClient
implements Client {
    private final Configuration configuration;

    public HttpComponentsClient(Configuration configuration) {
        this.configuration = configuration;
    }

    private CloseableHttpClient getClient() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        ArrayList<BasicHeader> defaultHeaders = new ArrayList<BasicHeader>();
        defaultHeaders.add(new BasicHeader("Authorization", (Object)("Bearer " + this.configuration.getApiToken()), true));
        builder.setDefaultHeaders(defaultHeaders);
        return builder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HttpResult executeRequest(Request request) {
        try (CloseableHttpClient httpClient = this.getClient();){
            switch (request.getMethod()) {
                case GET: {
                    HttpResult httpResult = this.executeGetRequest(request, httpClient);
                    return httpResult;
                }
                case DELETE: {
                    HttpResult httpResult = this.executeDeleteRequest(request, httpClient);
                    return httpResult;
                }
                case PUT: {
                    HttpResult httpResult = this.executePutRequest(request, httpClient);
                    return httpResult;
                }
                case POST: {
                    HttpResult httpResult = this.executePostRequest(request, httpClient);
                    return httpResult;
                }
            }
            throw new IllegalArgumentException("Invalid HttpType: " + (Object)((Object)request.getMethod()));
        }
        catch (IOException ioException) {
            throw new HttpRequestException(ioException.getMessage(), ioException);
        }
    }

    @Override
    public void close() {
    }

    private HttpResult executePostRequest(Request request, CloseableHttpClient httpClient) {
        try {
            HttpPost httpPost = new HttpPost(this.generateRequestUri(request));
            httpPost.setEntity((HttpEntity)new StringEntity(request.getRequestBody()));
            return this.submitRequest((ClassicHttpRequest)httpPost, httpClient);
        }
        catch (Exception exception) {
            throw new HttpRequestException(exception.getMessage(), exception);
        }
    }

    private HttpResult executePutRequest(Request request, CloseableHttpClient httpClient) {
        try {
            HttpPut httpPut = new HttpPut(this.generateRequestUri(request));
            return this.submitRequest((ClassicHttpRequest)httpPut, httpClient);
        }
        catch (Exception exception) {
            throw new HttpRequestException(exception.getMessage(), exception);
        }
    }

    private HttpResult executeGetRequest(Request request, CloseableHttpClient httpClient) {
        try {
            HttpGet httpGet = new HttpGet(this.generateRequestUri(request));
            return this.submitRequest((ClassicHttpRequest)httpGet, httpClient);
        }
        catch (Exception exception) {
            throw new HttpRequestException(exception.getMessage(), exception);
        }
    }

    private HttpResult executeDeleteRequest(Request request, CloseableHttpClient httpClient) {
        HttpDelete httpDelete = new HttpDelete(this.generateRequestUri(request));
        return this.submitRequest((ClassicHttpRequest)httpDelete, httpClient);
    }

    private URI generateRequestUri(Request request) {
        try {
            String path = this.configuration.getApiUrl() + request.getPath();
            URIBuilder uriBuilder = new URIBuilder(path).setCharset(StandardCharsets.UTF_8);
            for (RequestParameter requestParameter : request.getRequestParameters().getParameters()) {
                for (String value : requestParameter.getValues()) {
                    uriBuilder.setParameter(requestParameter.getName(), value);
                }
            }
            return uriBuilder.build();
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new HttpRequestException(uriSyntaxException.getMessage(), uriSyntaxException);
        }
    }

    private HttpResult submitRequest(ClassicHttpRequest httpRequest, CloseableHttpClient httpClient) {
        HttpResult httpResult;
        block11: {
            CloseableHttpResponse response = httpClient.execute(httpRequest);
            try {
                HttpResult result;
                String responseStr;
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    responseStr = EntityUtils.toString((HttpEntity)entity);
                    EntityUtils.consume((HttpEntity)entity);
                } else {
                    responseStr = "";
                }
                ArrayList<HttpHeader> allHeaders = new ArrayList<HttpHeader>();
                for (Header header : response.getHeaders()) {
                    allHeaders.add(new HttpHeader(header.getName(), header.getValue()));
                }
                httpResult = result = new HttpResult(response.getCode(), responseStr, new HttpHeaders(allHeaders));
                if (response == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | ParseException e) {
                    throw new HttpRequestException(e.getMessage(), e);
                }
            }
            response.close();
        }
        return httpResult;
    }
}

