/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client.request;

import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sourcelab.buildkite.api.client.request.BuildFiltersBuilder;
import org.sourcelab.buildkite.api.client.request.Filters;
import org.sourcelab.buildkite.api.client.request.PageOptions;

public class BuildFilters
implements Filters {
    private final Set<String> branches;
    private final Set<String> commits;
    private final ZonedDateTime createdFrom;
    private final ZonedDateTime createdTo;
    private final String creator;
    private final ZonedDateTime finishedFrom;
    private final Boolean includeRetriedJobs;
    private final Map<String, String> metaData;
    private final Set<String> states;
    private final PageOptions pageOptions;
    private final String orgIdSlug;
    private final String pipelineIdSlug;

    public static BuildFiltersBuilder newBuilder() {
        return new BuildFiltersBuilder();
    }

    public BuildFilters(Set<String> branches, Set<String> commits, ZonedDateTime createdFrom, ZonedDateTime createdTo, String creator, ZonedDateTime finishedFrom, Boolean includeRetriedJobs, Map<String, String> metaData, Set<String> states, PageOptions pageOptions, String orgIdSlug, String pipelineSlugId) {
        this.branches = Collections.unmodifiableSet(new HashSet<String>(branches));
        this.commits = Collections.unmodifiableSet(new HashSet<String>(commits));
        this.createdFrom = createdFrom;
        this.createdTo = createdTo;
        this.creator = creator;
        this.finishedFrom = finishedFrom;
        this.includeRetriedJobs = includeRetriedJobs;
        this.metaData = Collections.unmodifiableMap(new HashMap<String, String>(metaData));
        this.states = Collections.unmodifiableSet(new HashSet<String>(states));
        this.pageOptions = pageOptions == null ? PageOptions.getDefault() : pageOptions;
        this.orgIdSlug = orgIdSlug;
        this.pipelineIdSlug = pipelineSlugId;
    }

    public Set<String> getBranches() {
        return this.branches;
    }

    public Set<String> getCommits() {
        return this.commits;
    }

    public ZonedDateTime getCreatedFrom() {
        return this.createdFrom;
    }

    public ZonedDateTime getCreatedTo() {
        return this.createdTo;
    }

    public String getCreator() {
        return this.creator;
    }

    public ZonedDateTime getFinishedFrom() {
        return this.finishedFrom;
    }

    public Boolean getIncludeRetriedJobs() {
        return this.includeRetriedJobs;
    }

    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public Set<String> getStates() {
        return this.states;
    }

    @Override
    public PageOptions getPageOptions() {
        return this.pageOptions;
    }

    public String getOrgIdSlug() {
        return this.orgIdSlug;
    }

    public boolean hasOrgIdSlug() {
        return this.orgIdSlug != null;
    }

    public String getPipelineIdSlug() {
        return this.pipelineIdSlug;
    }

    public boolean hasPipelineIdSlug() {
        return this.hasOrgIdSlug() && this.pipelineIdSlug != null;
    }

    public String toString() {
        return "BuildFilters{branches=" + this.branches + ", commits=" + this.commits + ", createdFrom=" + this.createdFrom + ", createdTo=" + this.createdTo + ", creator='" + this.creator + '\'' + ", finishedFrom=" + this.finishedFrom + ", includeRetriedJobs=" + this.includeRetriedJobs + ", metaData=" + this.metaData + ", states=" + this.states + ", pageOptions=" + this.pageOptions + ", orgIdSlug='" + this.orgIdSlug + '\'' + ", pipelineIdSlug='" + this.pipelineIdSlug + '\'' + '}';
    }
}

