/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client.request;

import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.sourcelab.buildkite.api.client.exception.BuilderValidationException;
import org.sourcelab.buildkite.api.client.request.BuildFilters;
import org.sourcelab.buildkite.api.client.request.PageOptions;
import org.sourcelab.buildkite.api.client.request.StateChooser;

public final class BuildFiltersBuilder {
    private Set<String> branches = new HashSet<String>();
    private Set<String> commits = new HashSet<String>();
    private ZonedDateTime createdFrom = null;
    private ZonedDateTime createdTo = null;
    private String creator = null;
    private ZonedDateTime finishedFrom = null;
    private Boolean includeRetriedJobs = null;
    private Map<String, String> metaData = new HashMap<String, String>();
    private Set<String> states = new HashSet<String>();
    private PageOptions pageOptions = null;
    private String orgIdSlug = null;
    private String pipelineIdSlug = null;

    public BuildFiltersBuilder withBranch(String branch) {
        this.branches.add(branch);
        return this;
    }

    public BuildFiltersBuilder withBranches(String ... branches) {
        this.branches.addAll(Arrays.asList(branches));
        return this;
    }

    public BuildFiltersBuilder withBranches(Collection<String> branches) {
        Objects.requireNonNull(branches);
        this.branches.addAll(branches);
        return this;
    }

    public BuildFiltersBuilder withCommit(String commit) {
        this.commits.add(commit);
        return this;
    }

    public BuildFiltersBuilder withCommits(String ... commits) {
        this.commits.addAll(Arrays.asList(commits));
        return this;
    }

    public BuildFiltersBuilder withCommits(Collection<String> commits) {
        Objects.requireNonNull(commits);
        this.commits.addAll(commits);
        return this;
    }

    public BuildFiltersBuilder withCreatedFrom(ZonedDateTime createdFrom) {
        this.createdFrom = createdFrom;
        return this;
    }

    public BuildFiltersBuilder withCreatedTo(ZonedDateTime createdTo) {
        this.createdTo = createdTo;
        return this;
    }

    public BuildFiltersBuilder withCreator(String creatorUuid) {
        this.creator = creatorUuid;
        return this;
    }

    public BuildFiltersBuilder withFinishedFrom(ZonedDateTime finishedFrom) {
        this.finishedFrom = finishedFrom;
        return this;
    }

    public BuildFiltersBuilder withIncludeRetriedJobs(Boolean includeRetriedJobs) {
        this.includeRetriedJobs = includeRetriedJobs == false ? null : includeRetriedJobs;
        return this;
    }

    public BuildFiltersBuilder withMetaData(String name, Object value) {
        Objects.requireNonNull(name);
        if (value == null) {
            this.metaData.remove(name);
        } else {
            this.metaData.put(name, value.toString());
        }
        return this;
    }

    public BuildFiltersBuilder withMetaData(Map<String, String> metaData) {
        Objects.requireNonNull(metaData);
        this.metaData.putAll(metaData);
        return this;
    }

    public StateChooser withStateChooser() {
        return new StateChooser(this);
    }

    public BuildFiltersBuilder withState(String state) {
        this.states.add(state);
        return this;
    }

    public BuildFiltersBuilder withStates(String ... states) {
        this.states.addAll(Arrays.asList(states));
        return this;
    }

    public BuildFiltersBuilder withStates(Collection<String> states) {
        Objects.requireNonNull(states);
        this.states.addAll(states);
        return this;
    }

    public BuildFiltersBuilder withPerPage(int perPage) {
        if (this.pageOptions == null) {
            this.withPageOptions(PageOptions.getDefault());
        }
        return this.withPageOptions(new PageOptions(this.pageOptions.getPage(), perPage));
    }

    public BuildFiltersBuilder withPage(int page) {
        if (this.pageOptions == null) {
            this.withPageOptions(PageOptions.getDefault());
        }
        return this.withPageOptions(new PageOptions(page, this.pageOptions.getPerPage()));
    }

    public BuildFiltersBuilder withPageOptions(int page, int perPage) {
        return this.withPageOptions(new PageOptions(page, perPage));
    }

    public BuildFiltersBuilder withPageOptions(PageOptions pageOptions) {
        this.pageOptions = pageOptions;
        return this;
    }

    public BuildFiltersBuilder withOrganization(String orgIdSlug) {
        this.orgIdSlug = orgIdSlug;
        return this;
    }

    public BuildFiltersBuilder withPipeline(String orgIdSlug, String pipelineIdSlug) {
        this.pipelineIdSlug = pipelineIdSlug;
        return this.withOrganization(orgIdSlug);
    }

    public BuildFilters build() {
        if (this.pipelineIdSlug != null && this.orgIdSlug == null) {
            throw new BuilderValidationException("If Pipeline is provided, then Organization must be provided.");
        }
        return new BuildFilters(this.branches, this.commits, this.createdFrom, this.createdTo, this.creator, this.finishedFrom, this.includeRetriedJobs, this.metaData, this.states, this.pageOptions, this.orgIdSlug, this.pipelineIdSlug);
    }
}

