/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client.request;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sourcelab.buildkite.api.client.request.CreateBuildOptionsBuilder;
import org.sourcelab.buildkite.api.client.response.Author;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CreateBuildOptions {
    @JsonIgnore
    private final String organizationIdSlug;
    @JsonIgnore
    private final String pipelineIdSlug;
    private final String commit;
    private final String branch;
    private final String message;
    private final Author author;
    private final Map<String, String> env;
    private final Map<String, String> meta;
    private final String cleanCheckout;
    private final String ignorePipelineBranchFilters;
    private final String pullRequestBaseBranch;
    private final String pullRequestId;
    private final String pullRequestRepository;

    public static CreateBuildOptionsBuilder newBuilder() {
        return new CreateBuildOptionsBuilder();
    }

    public CreateBuildOptions(String organizationIdSlug, String pipelineIdSlug, String commitId, String branch, String message, Author author, Map<String, String> env, Map<String, String> meta, Boolean cleanCheckout, Boolean ignorePipelineBranchFilters, String pullRequestBaseBranch, String pullRequestId, String pullRequestRepository) {
        this.organizationIdSlug = organizationIdSlug;
        this.pipelineIdSlug = pipelineIdSlug;
        this.commit = commitId;
        this.branch = branch;
        this.message = message;
        this.author = author;
        HashMap<String, String> envMap = new HashMap<String, String>();
        if (env != null) {
            envMap.putAll(env);
        }
        this.env = Collections.unmodifiableMap(envMap);
        HashMap<String, String> metaMap = new HashMap<String, String>();
        if (meta != null) {
            metaMap.putAll(meta);
        }
        this.meta = Collections.unmodifiableMap(metaMap);
        this.ignorePipelineBranchFilters = ignorePipelineBranchFilters != null ? (ignorePipelineBranchFilters.booleanValue() ? "true" : "false") : null;
        this.cleanCheckout = cleanCheckout != null ? (cleanCheckout.booleanValue() ? "true" : "false") : null;
        this.pullRequestBaseBranch = pullRequestBaseBranch;
        this.pullRequestId = pullRequestId;
        this.pullRequestRepository = pullRequestRepository;
    }

    public String getOrganizationIdSlug() {
        return this.organizationIdSlug;
    }

    public String getPipelineIdSlug() {
        return this.pipelineIdSlug;
    }

    @JsonGetter(value="commit")
    public String getCommit() {
        return this.commit;
    }

    @JsonGetter(value="branch")
    public String getBranch() {
        return this.branch;
    }

    @JsonGetter(value="message")
    public String getMessage() {
        return this.message;
    }

    @JsonGetter(value="author")
    public Author getAuthor() {
        return this.author;
    }

    @JsonGetter(value="env")
    public Map<String, String> getEnv() {
        return this.env;
    }

    @JsonGetter(value="meta")
    public Map<String, String> getMeta() {
        return this.meta;
    }

    @JsonGetter(value="clean_checkout")
    public String getCleanCheckout() {
        return this.cleanCheckout;
    }

    @JsonGetter(value="ignore_pipeline_branch_filters")
    public String getIgnorePipelineBranchFilters() {
        return this.ignorePipelineBranchFilters;
    }

    @JsonGetter(value="pull_request_base_branch")
    public String getPullRequestBaseBranch() {
        return this.pullRequestBaseBranch;
    }

    @JsonGetter(value="pull_request_id")
    public String getPullRequestId() {
        return this.pullRequestId;
    }

    @JsonGetter(value="pull_request_repository")
    public String getPullRequestRepository() {
        return this.pullRequestRepository;
    }

    public String toString() {
        return "CreateBuildOptions{organizationIdSlug='" + this.organizationIdSlug + '\'' + ", pipelineIdSlug='" + this.pipelineIdSlug + '\'' + ", commitId='" + this.commit + '\'' + ", branch='" + this.branch + '\'' + ", message='" + this.message + '\'' + ", author=" + this.author + ", env=" + this.env + ", meta=" + this.meta + '}';
    }
}

