/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client.request;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.sourcelab.buildkite.api.client.exception.BuilderValidationException;
import org.sourcelab.buildkite.api.client.request.CreateBuildOptions;
import org.sourcelab.buildkite.api.client.response.Author;

public final class CreateBuildOptionsBuilder {
    private String organizationIdSlug = null;
    private String pipelineIdSlug = null;
    private String commit = null;
    private String branch = null;
    private String message = null;
    private Author author = null;
    private Map<String, String> env = new HashMap<String, String>();
    private Map<String, String> meta = new HashMap<String, String>();
    private Boolean cleanCheckout = null;
    private Boolean ignorePipelineBranchFilters = null;
    private String pullRequestBaseBranch = null;
    private String pullRequestId = null;
    private String pullRequestRepository = null;

    public CreateBuildOptionsBuilder withOrganization(String organizationSlug) {
        this.organizationIdSlug = organizationSlug;
        return this;
    }

    public CreateBuildOptionsBuilder withPipeline(String pipelineSlug) {
        this.pipelineIdSlug = pipelineSlug;
        return this;
    }

    public CreateBuildOptionsBuilder withPipeline(String organizationSlug, String pipelineSlug) {
        this.pipelineIdSlug = pipelineSlug;
        this.organizationIdSlug = organizationSlug;
        return this;
    }

    public CreateBuildOptionsBuilder withCommit(String commit) {
        this.commit = commit;
        return this;
    }

    public CreateBuildOptionsBuilder withBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public CreateBuildOptionsBuilder withMessage(String message) {
        this.message = message;
        return this;
    }

    public CreateBuildOptionsBuilder withAuthor(Author author) {
        this.author = author;
        return this;
    }

    public CreateBuildOptionsBuilder withAuthor(String authorName, String authorEmail) {
        return this.withAuthor(new Author("", authorName, authorEmail));
    }

    public CreateBuildOptionsBuilder withEnv(Map<String, String> env) {
        this.env.putAll(Objects.requireNonNull(env));
        return this;
    }

    public CreateBuildOptionsBuilder withEnv(String key, String value) {
        this.env.put(key, value);
        return this;
    }

    public CreateBuildOptionsBuilder withMeta(Map<String, String> meta) {
        this.meta.putAll(Objects.requireNonNull(meta));
        return this;
    }

    public CreateBuildOptionsBuilder withMeta(String key, String value) {
        this.meta.put(key, value);
        return this;
    }

    public CreateBuildOptionsBuilder withCleanCheckout(boolean useCleanCheckout) {
        this.cleanCheckout = useCleanCheckout;
        return this;
    }

    public CreateBuildOptionsBuilder withIgnorePipelineBranchFilters(boolean ignorePipelineBranchFilters) {
        this.ignorePipelineBranchFilters = ignorePipelineBranchFilters;
        return this;
    }

    public CreateBuildOptionsBuilder withPullRequestBaseBranch(String pullRequestBaseBranch) {
        this.pullRequestBaseBranch = pullRequestBaseBranch;
        return this;
    }

    public CreateBuildOptionsBuilder withPullRequestId(String pullRequestId) {
        this.pullRequestId = pullRequestId;
        return this;
    }

    public CreateBuildOptionsBuilder withPullRequestId(long pullRequestId) {
        this.pullRequestId = Long.toString(pullRequestId);
        return this;
    }

    public CreateBuildOptionsBuilder withPullRequestId(int pullRequestId) {
        this.pullRequestId = Integer.toString(pullRequestId);
        return this;
    }

    public CreateBuildOptionsBuilder withPullRequestRepository(String pullRequestRepository) {
        this.pullRequestRepository = pullRequestRepository;
        return this;
    }

    public CreateBuildOptions build() {
        if (this.organizationIdSlug == null) {
            throw new BuilderValidationException("Organization must be provided.");
        }
        if (this.pipelineIdSlug == null) {
            throw new BuilderValidationException("Pipeline must be provided.");
        }
        if (this.commit == null) {
            throw new BuilderValidationException("CommitId must be provided.");
        }
        if (this.branch == null) {
            throw new BuilderValidationException("Branch must be provided.");
        }
        return new CreateBuildOptions(this.organizationIdSlug, this.pipelineIdSlug, this.commit, this.branch, this.message, this.author, this.env, this.meta, this.cleanCheckout, this.ignorePipelineBranchFilters, this.pullRequestBaseBranch, this.pullRequestId, this.pullRequestRepository);
    }
}

