/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client.request;

import com.fasterxml.jackson.core.JsonProcessingException;
import org.sourcelab.buildkite.api.client.exception.RequestParsingException;
import org.sourcelab.buildkite.api.client.request.CreateBuildOptions;
import org.sourcelab.buildkite.api.client.request.PostRequest;
import org.sourcelab.buildkite.api.client.response.Build;
import org.sourcelab.buildkite.api.client.response.parser.GetBuildResponseParser;
import org.sourcelab.buildkite.api.client.response.parser.JacksonFactory;
import org.sourcelab.buildkite.api.client.response.parser.ResponseParser;

public class CreateBuildRequest
extends PostRequest<Build> {
    private final CreateBuildOptions buildOptions;

    public CreateBuildRequest(CreateBuildOptions buildOptions) {
        this.buildOptions = buildOptions;
    }

    @Override
    public String getPath() {
        return "/v2/organizations/" + this.buildOptions.getOrganizationIdSlug() + "/pipelines/" + this.buildOptions.getPipelineIdSlug() + "/builds";
    }

    @Override
    public String getRequestBody() {
        try {
            return JacksonFactory.newInstance().writeValueAsString((Object)this.buildOptions);
        }
        catch (JsonProcessingException e) {
            throw new RequestParsingException(e.getMessage(), e);
        }
    }

    @Override
    public ResponseParser<Build> getResponseParser() {
        return new GetBuildResponseParser();
    }
}

