/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client.request;

import java.util.Objects;
import org.sourcelab.buildkite.api.client.exception.BuilderValidationException;
import org.sourcelab.buildkite.api.client.request.GetBuildFilters;

public final class GetBuildFiltersBuilder {
    private String orgIdSlug = null;
    private String pipelineIdSlug = null;
    private Long buildNumber = null;
    private Boolean includeRetriedJobs = null;

    public GetBuildFiltersBuilder withOrgIdSlug(String orgIdSlug) {
        this.orgIdSlug = Objects.requireNonNull(orgIdSlug);
        return this;
    }

    public GetBuildFiltersBuilder withPipelineIdSlug(String pipelineIdSlug) {
        this.pipelineIdSlug = Objects.requireNonNull(pipelineIdSlug);
        return this;
    }

    public GetBuildFiltersBuilder withBuildNumber(long buildNumber) {
        this.buildNumber = buildNumber;
        return this;
    }

    public GetBuildFiltersBuilder withIncludeRetriedJobs(boolean includeRetriedJobs) {
        this.includeRetriedJobs = includeRetriedJobs;
        return this;
    }

    public GetBuildFilters build() {
        if (this.pipelineIdSlug == null) {
            throw new BuilderValidationException("Pipeline must be provided.");
        }
        if (this.orgIdSlug == null) {
            throw new BuilderValidationException("Organization must be provided.");
        }
        if (this.buildNumber == null) {
            throw new BuilderValidationException("Build Number must be provided.");
        }
        return new GetBuildFilters(this.orgIdSlug, this.pipelineIdSlug, this.buildNumber, this.includeRetriedJobs);
    }
}

