/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client.request;

import java.util.Objects;
import org.sourcelab.buildkite.api.client.request.GetBuildFilters;
import org.sourcelab.buildkite.api.client.request.GetRequest;
import org.sourcelab.buildkite.api.client.request.RequestParameters;
import org.sourcelab.buildkite.api.client.request.RequestParametersBuilder;
import org.sourcelab.buildkite.api.client.response.Build;
import org.sourcelab.buildkite.api.client.response.parser.GetBuildResponseParser;
import org.sourcelab.buildkite.api.client.response.parser.ResponseParser;

public class GetBuildRequest
extends GetRequest<Build> {
    private final GetBuildFilters filters;

    public GetBuildRequest(GetBuildFilters filters) {
        this.filters = Objects.requireNonNull(filters);
    }

    @Override
    public String getPath() {
        return "/v2/organizations/" + this.filters.getOrgIdSlug() + "/pipelines/" + this.filters.getPipelineIdSlug() + "/builds/" + this.filters.getBuildNumber();
    }

    @Override
    public RequestParameters getRequestParameters() {
        RequestParametersBuilder builder = RequestParameters.newBuilder();
        if (this.filters.getIncludeRetriedJobs() != null) {
            if (this.filters.getIncludeRetriedJobs().booleanValue()) {
                builder.withParameter("include_retried_jobs", (Object)"true");
            } else {
                builder.withParameter("include_retried_jobs", (Object)"false");
            }
        }
        return builder.build();
    }

    @Override
    public ResponseParser<Build> getResponseParser() {
        return new GetBuildResponseParser();
    }
}

