/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client.request;

import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;
import org.sourcelab.buildkite.api.client.request.BuildFilters;
import org.sourcelab.buildkite.api.client.request.GetRequest;
import org.sourcelab.buildkite.api.client.request.PageOptions;
import org.sourcelab.buildkite.api.client.request.PageableRequest;
import org.sourcelab.buildkite.api.client.request.RequestParameters;
import org.sourcelab.buildkite.api.client.request.RequestParametersBuilder;
import org.sourcelab.buildkite.api.client.response.ListBuildsResponse;
import org.sourcelab.buildkite.api.client.response.parser.ListBuildsResponseParser;
import org.sourcelab.buildkite.api.client.response.parser.ResponseParser;

public class ListBuildsRequest
extends GetRequest<ListBuildsResponse>
implements PageableRequest<ListBuildsResponse> {
    private final BuildFilters filters;
    private PageOptions pageOptions;

    public ListBuildsRequest(BuildFilters filters) {
        Objects.requireNonNull(filters);
        this.filters = filters;
        this.pageOptions = filters.getPageOptions() == null ? PageOptions.getDefault() : filters.getPageOptions();
    }

    @Override
    public String getPath() {
        if (this.filters.hasPipelineIdSlug()) {
            return "/v2/organizations/" + this.filters.getOrgIdSlug() + "/pipelines/" + this.filters.getPipelineIdSlug() + "/builds";
        }
        if (this.filters.hasOrgIdSlug()) {
            return "/v2/organizations/" + this.filters.getOrgIdSlug() + "/builds";
        }
        return "/v2/builds";
    }

    @Override
    public RequestParameters getRequestParameters() {
        RequestParametersBuilder builder = RequestParameters.newBuilder();
        builder.withParameter("per_page", (Object)this.pageOptions.getPerPage());
        builder.withParameter("page", (Object)this.pageOptions.getPage());
        if (!this.filters.getBranches().isEmpty()) {
            builder.withParameter("branch", this.filters.getBranches());
        }
        if (!this.filters.getCommits().isEmpty()) {
            builder.withParameter("commit", this.filters.getCommits());
        }
        if (!this.filters.getStates().isEmpty()) {
            builder.withParameter("state", this.filters.getStates());
        }
        if (this.filters.getCreator() != null) {
            builder.withParameter("creator", (Object)this.filters.getCreator());
        }
        if (this.filters.getIncludeRetriedJobs() != null) {
            String booleanStr = this.filters.getIncludeRetriedJobs() != false ? "true" : "false";
            builder.withParameter("include_retried_jobs", (Object)booleanStr);
        }
        for (Map.Entry<String, String> entry : this.filters.getMetaData().entrySet()) {
            builder.withParameter("metadata[" + entry.getKey() + "]", (Object)entry.getValue());
        }
        if (this.filters.getCreatedFrom() != null) {
            builder.withParameter("created_from", (Object)this.filters.getCreatedFrom().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
        if (this.filters.getCreatedTo() != null) {
            builder.withParameter("created_to", (Object)this.filters.getCreatedTo().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
        if (this.filters.getFinishedFrom() != null) {
            builder.withParameter("finished_from", (Object)this.filters.getFinishedFrom().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
        return builder.build();
    }

    @Override
    public ResponseParser<ListBuildsResponse> getResponseParser() {
        return new ListBuildsResponseParser(this);
    }

    @Override
    public void updatePageOptions(PageOptions pageOptions) {
        this.pageOptions = Objects.requireNonNull(pageOptions);
    }
}

