/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client.request;

import java.util.Objects;
import org.sourcelab.buildkite.api.client.request.GetRequest;
import org.sourcelab.buildkite.api.client.request.OrganizationFilters;
import org.sourcelab.buildkite.api.client.request.PageOptions;
import org.sourcelab.buildkite.api.client.request.PageableRequest;
import org.sourcelab.buildkite.api.client.request.RequestParameters;
import org.sourcelab.buildkite.api.client.request.RequestParametersBuilder;
import org.sourcelab.buildkite.api.client.response.ListOrganizationsResponse;
import org.sourcelab.buildkite.api.client.response.parser.ListOrganizationsResponseParser;
import org.sourcelab.buildkite.api.client.response.parser.ResponseParser;

public class ListOrganizationsRequest
extends GetRequest<ListOrganizationsResponse>
implements PageableRequest<ListOrganizationsResponse> {
    private final OrganizationFilters filters;
    private PageOptions pageOptions;

    public ListOrganizationsRequest(OrganizationFilters filters) {
        Objects.requireNonNull(filters);
        this.filters = filters;
        this.pageOptions = filters.getPageOptions() == null ? PageOptions.getDefault() : filters.getPageOptions();
    }

    @Override
    public String getPath() {
        if (this.filters.hasOrgIdSlug()) {
            return "/v2/organizations/" + this.filters.getOrgIdSlug();
        }
        return "/v2/organizations";
    }

    @Override
    public RequestParameters getRequestParameters() {
        RequestParametersBuilder builder = RequestParameters.newBuilder();
        builder.withParameter("per_page", (Object)this.pageOptions.getPerPage());
        builder.withParameter("page", (Object)this.pageOptions.getPage());
        return builder.build();
    }

    @Override
    public ResponseParser<ListOrganizationsResponse> getResponseParser() {
        return new ListOrganizationsResponseParser(this);
    }

    @Override
    public void updatePageOptions(PageOptions pageOptions) {
        this.pageOptions = Objects.requireNonNull(pageOptions);
    }
}

