/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client.request;

import java.util.Objects;
import org.sourcelab.buildkite.api.client.request.GetRequest;
import org.sourcelab.buildkite.api.client.request.PageOptions;
import org.sourcelab.buildkite.api.client.request.PageableRequest;
import org.sourcelab.buildkite.api.client.request.PipelineFilters;
import org.sourcelab.buildkite.api.client.request.RequestParameters;
import org.sourcelab.buildkite.api.client.request.RequestParametersBuilder;
import org.sourcelab.buildkite.api.client.response.ListPipelinesResponse;
import org.sourcelab.buildkite.api.client.response.parser.ListPipelinesResponseParser;
import org.sourcelab.buildkite.api.client.response.parser.ResponseParser;

public class ListPipelinesRequest
extends GetRequest<ListPipelinesResponse>
implements PageableRequest<ListPipelinesResponse> {
    private final PipelineFilters filters;
    private PageOptions pageOptions;

    public ListPipelinesRequest(PipelineFilters filters) {
        Objects.requireNonNull(filters);
        this.filters = filters;
        this.pageOptions = filters.getPageOptions() == null ? PageOptions.getDefault() : filters.getPageOptions();
    }

    @Override
    public String getPath() {
        return "/v2/organizations/" + this.filters.getOrgIdSlug() + "/pipelines";
    }

    @Override
    public RequestParameters getRequestParameters() {
        RequestParametersBuilder builder = RequestParameters.newBuilder();
        builder.withParameter("per_page", (Object)this.pageOptions.getPerPage());
        builder.withParameter("page", (Object)this.pageOptions.getPage());
        return builder.build();
    }

    @Override
    public ResponseParser<ListPipelinesResponse> getResponseParser() {
        return new ListPipelinesResponseParser(this);
    }

    @Override
    public void updatePageOptions(PageOptions pageOptions) {
        this.pageOptions = Objects.requireNonNull(pageOptions);
    }
}

