/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client.request;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PageOptions {
    private final long page;
    private final int perPage;
    private static final PageOptions DEFAULT = new PageOptions(1L, 30);

    public static PageOptions getDefault() {
        return DEFAULT;
    }

    public PageOptions(long page, int perPage) {
        if (page < 0L) {
            page = 1L;
        }
        this.page = page;
        if (perPage < 0) {
            perPage = 1;
        } else if (perPage > 100) {
            perPage = 100;
        }
        this.perPage = perPage;
    }

    public static PageOptions fromUrl(String url) {
        Matcher pageMatcher;
        Objects.requireNonNull(url);
        Pattern perPagePattern = Pattern.compile(".*[?&]per_page=([0-9]+).*");
        Pattern pagePattern = Pattern.compile(".*[?&]page=([0-9]+).*");
        Integer perPage = null;
        Integer page = null;
        Matcher perPageMatcher = perPagePattern.matcher(url);
        if (perPageMatcher.matches() && perPageMatcher.groupCount() == 1) {
            perPage = Integer.parseInt(perPageMatcher.group(1));
        }
        if ((pageMatcher = pagePattern.matcher(url)).matches() && pageMatcher.groupCount() == 1) {
            page = Integer.parseInt(pageMatcher.group(1));
        }
        if (perPage == null || page == null) {
            throw new IllegalArgumentException("Unable to parse url " + url);
        }
        return new PageOptions(page.intValue(), perPage);
    }

    public long getPage() {
        return this.page;
    }

    public int getPerPage() {
        return this.perPage;
    }

    public String toString() {
        return "PageOptions{page=" + this.page + ", perPage=" + this.perPage + '}';
    }
}

