/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client.request;

import org.sourcelab.buildkite.api.client.exception.BuilderValidationException;
import org.sourcelab.buildkite.api.client.request.PageOptions;
import org.sourcelab.buildkite.api.client.request.PipelineFilters;

public final class PipelineFiltersBuilder {
    private PageOptions pageOptions = null;
    private String orgIdSlug = null;

    public PipelineFiltersBuilder withPerPage(int perPage) {
        if (this.pageOptions == null) {
            this.withPageOptions(PageOptions.getDefault());
        }
        return this.withPageOptions(new PageOptions(this.pageOptions.getPage(), perPage));
    }

    public PipelineFiltersBuilder withPage(int page) {
        if (this.pageOptions == null) {
            this.withPageOptions(PageOptions.getDefault());
        }
        return this.withPageOptions(new PageOptions(page, this.pageOptions.getPerPage()));
    }

    public PipelineFiltersBuilder withPageOptions(int page, int perPage) {
        return this.withPageOptions(new PageOptions(page, perPage));
    }

    public PipelineFiltersBuilder withPageOptions(PageOptions pageOptions) {
        this.pageOptions = pageOptions;
        return this;
    }

    public PipelineFiltersBuilder withOrganization(String orgIdSlug) {
        this.orgIdSlug = orgIdSlug;
        return this;
    }

    public PipelineFilters build() {
        if (this.orgIdSlug == null) {
            throw new BuilderValidationException("Organization must be provided.");
        }
        return new PipelineFilters(this.pageOptions, this.orgIdSlug);
    }
}

