/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client.request;

import java.io.IOException;
import java.util.Collections;
import org.sourcelab.buildkite.api.client.exception.RequestParsingException;
import org.sourcelab.buildkite.api.client.exception.ResponseParsingException;
import org.sourcelab.buildkite.api.client.http.HttpResult;
import org.sourcelab.buildkite.api.client.request.HttpMethod;
import org.sourcelab.buildkite.api.client.request.RequestParameters;
import org.sourcelab.buildkite.api.client.response.parser.ResponseParser;

public interface Request<T> {
    public HttpMethod getMethod();

    public String getPath();

    default public RequestParameters getRequestParameters() {
        return new RequestParameters(Collections.emptyList());
    }

    default public String getRequestBody() throws RequestParsingException {
        return null;
    }

    public ResponseParser<T> getResponseParser();

    default public T parseResponse(HttpResult result) {
        try {
            return this.getResponseParser().parseResponse(result);
        }
        catch (IOException parseException) {
            String message = "Unable to parse response from API: " + parseException.getMessage() + "\nResponse From API: \n" + result.getContent();
            throw new ResponseParsingException(message, parseException);
        }
    }
}

