/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public class RequestParameter {
    private String name;
    private Collection<String> values;

    public RequestParameter(String name, Collection<String> values) {
        this.name = Objects.requireNonNull(name);
        this.values = Collections.unmodifiableCollection(new ArrayList<String>(Objects.requireNonNull(values)));
    }

    public RequestParameter(String name, String value) {
        this.name = name;
        Objects.requireNonNull(value);
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        this.values = Collections.unmodifiableCollection(values);
    }

    public String getName() {
        if (this.getValues().size() > 1) {
            return this.name + "[]";
        }
        return this.name;
    }

    public Collection<String> getValues() {
        return this.values;
    }

    public String toString() {
        return "RequestParameter{name='" + this.name + '\'' + ", values=" + this.values + '}';
    }
}

