/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client.request;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.sourcelab.buildkite.api.client.request.RequestParameter;
import org.sourcelab.buildkite.api.client.request.RequestParametersBuilder;

public class RequestParameters {
    final Map<String, RequestParameter> parameters;

    public static RequestParametersBuilder newBuilder() {
        return new RequestParametersBuilder();
    }

    public RequestParameters(Collection<RequestParameter> parameters) {
        HashMap parameterMap = new HashMap();
        parameters.forEach(parameter -> {
            Objects.requireNonNull(parameter.getName());
            if (parameterMap.containsKey(parameter.getName())) {
                throw new IllegalArgumentException("Parameter name '" + parameter.getName() + "' provided multiple times!");
            }
            parameterMap.put(parameter.getName(), parameter);
        });
        this.parameters = Collections.unmodifiableMap(parameterMap);
    }

    public Set<String> getParameterNames() {
        return this.parameters.keySet().stream().sorted().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public boolean hasParameter(String name) {
        return this.parameters.containsKey(name);
    }

    public Collection<RequestParameter> getParameters() {
        return this.parameters.values();
    }

    public RequestParameter getParameterByName(String name) {
        Objects.requireNonNull(name);
        if (!this.hasParameter(name)) {
            throw new IllegalArgumentException("Parameter '" + name + "' not defined in set!");
        }
        return this.parameters.get(name);
    }

    public int size() {
        return this.getParameters().size();
    }

    public String toString() {
        return "RequestParameters{parameters=" + this.parameters + '}';
    }
}

