/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client.request;

import org.sourcelab.buildkite.api.client.exception.BuilderValidationException;
import org.sourcelab.buildkite.api.client.request.RetryJobOptions;

public final class RetryJobOptionsBuilder {
    private String organizationSlug = null;
    private String pipelineSlug = null;
    private Long buildNumber = null;
    private String jobId = null;

    public RetryJobOptionsBuilder withOrganizationSlug(String organizationSlug) {
        this.organizationSlug = organizationSlug;
        return this;
    }

    public RetryJobOptionsBuilder withPipelineSlug(String pipelineSlug) {
        this.pipelineSlug = pipelineSlug;
        return this;
    }

    public RetryJobOptionsBuilder withBuildNumber(long buildNumber) {
        this.buildNumber = buildNumber;
        return this;
    }

    public RetryJobOptionsBuilder withJobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    public RetryJobOptions build() {
        if (this.organizationSlug == null) {
            throw new BuilderValidationException("Organization must be provided.");
        }
        if (this.pipelineSlug == null) {
            throw new BuilderValidationException("Pipeline must be provided.");
        }
        if (this.buildNumber == null) {
            throw new BuilderValidationException("BuildNumber must be provided.");
        }
        if (this.jobId == null) {
            throw new BuilderValidationException("JobId must be provided.");
        }
        return new RetryJobOptions(this.organizationSlug, this.pipelineSlug, this.buildNumber, this.jobId);
    }
}

