/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client.request;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.sourcelab.buildkite.api.client.exception.BuilderValidationException;
import org.sourcelab.buildkite.api.client.request.RetryMultipleJobsOptions;

public final class RetryMultipleJobsOptionsBuilder {
    private String organizationSlug = null;
    private String pipelineSlug = null;
    private Long buildNumber = null;
    private Set<String> jobIds = new HashSet<String>();
    private boolean throwOnError = true;

    public RetryMultipleJobsOptionsBuilder withOrganizationSlug(String organizationSlug) {
        this.organizationSlug = organizationSlug;
        return this;
    }

    public RetryMultipleJobsOptionsBuilder withPipelineSlug(String pipelineSlug) {
        this.pipelineSlug = pipelineSlug;
        return this;
    }

    public RetryMultipleJobsOptionsBuilder withBuildNumber(long buildNumber) {
        this.buildNumber = buildNumber;
        return this;
    }

    public RetryMultipleJobsOptionsBuilder withJobId(String jobId) {
        this.jobIds.add(jobId);
        return this;
    }

    public RetryMultipleJobsOptionsBuilder withJobIds(Collection<String> jobIds) {
        this.jobIds.addAll(jobIds);
        return this;
    }

    public RetryMultipleJobsOptionsBuilder withThrowExceptionOnError(boolean throwExceptionOnError) {
        this.throwOnError = throwExceptionOnError;
        return this;
    }

    public RetryMultipleJobsOptions build() {
        if (this.organizationSlug == null) {
            throw new BuilderValidationException("Organization must be provided.");
        }
        if (this.pipelineSlug == null) {
            throw new BuilderValidationException("Pipeline must be provided.");
        }
        if (this.buildNumber == null) {
            throw new BuilderValidationException("BuildNumber must be provided.");
        }
        if (this.jobIds.isEmpty()) {
            throw new BuilderValidationException("At least one JobId must be provided.");
        }
        return new RetryMultipleJobsOptions(this.organizationSlug, this.pipelineSlug, this.buildNumber, this.jobIds, this.throwOnError);
    }
}

