/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client.request;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sourcelab.buildkite.api.client.request.RetryJobOptionsBuilder;

public class UnblockJobOptions {
    private final String organizationSlug;
    private final String pipelineSlug;
    private final long buildNumber;
    private final String jobId;
    private final String unblockerUserId;
    private final Map<String, String> fields;

    public static RetryJobOptionsBuilder newBuilder() {
        return new RetryJobOptionsBuilder();
    }

    public UnblockJobOptions(String organizationSlug, String pipelineIdSlug, long buildNumber, String jobId, String unblockerUserId, Map<String, String> fields) {
        this.organizationSlug = organizationSlug;
        this.pipelineSlug = pipelineIdSlug;
        this.buildNumber = buildNumber;
        this.jobId = jobId;
        this.unblockerUserId = unblockerUserId;
        HashMap<String, String> fieldsMap = new HashMap<String, String>();
        if (fields != null) {
            fieldsMap.putAll(fields);
        }
        this.fields = Collections.unmodifiableMap(fieldsMap);
    }

    public String getOrganizationSlug() {
        return this.organizationSlug;
    }

    public String getPipelineSlug() {
        return this.pipelineSlug;
    }

    public long getBuildNumber() {
        return this.buildNumber;
    }

    public String getJobId() {
        return this.jobId;
    }

    public boolean hasUnblockerUserId() {
        return this.unblockerUserId != null;
    }

    public String getUnblockerUserId() {
        return this.unblockerUserId;
    }

    public boolean hasFields() {
        return this.fields.size() > 0;
    }

    public Map<String, String> getFields() {
        return this.fields;
    }

    public String toString() {
        return "UnblockJobOptions{organizationSlug='" + this.organizationSlug + '\'' + ", pipelineSlug='" + this.pipelineSlug + '\'' + ", buildNumber=" + this.buildNumber + ", jobId='" + this.jobId + '\'' + ", unblockerUserId='" + this.unblockerUserId + '\'' + ", fields=" + this.fields + '}';
    }
}

