/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client.request;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.sourcelab.buildkite.api.client.exception.BuilderValidationException;
import org.sourcelab.buildkite.api.client.request.UnblockJobOptions;

public final class UnblockJobOptionsBuilder {
    private String organizationSlug = null;
    private String pipelineSlug = null;
    private Long buildNumber = null;
    private String jobId = null;
    private String unblockerUserId = null;
    private Map<String, String> fields = new HashMap<String, String>();

    public UnblockJobOptionsBuilder withOrganizationSlug(String organizationSlug) {
        this.organizationSlug = organizationSlug;
        return this;
    }

    public UnblockJobOptionsBuilder withPipelineSlug(String pipelineSlug) {
        this.pipelineSlug = pipelineSlug;
        return this;
    }

    public UnblockJobOptionsBuilder withBuildNumber(long buildNumber) {
        this.buildNumber = buildNumber;
        return this;
    }

    public UnblockJobOptionsBuilder withJobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    public UnblockJobOptionsBuilder withUnblocker(String userId) {
        this.unblockerUserId = userId;
        return this;
    }

    public UnblockJobOptionsBuilder withFields(Map<String, String> fields) {
        Objects.requireNonNull(fields);
        this.fields.putAll(fields);
        return this;
    }

    public UnblockJobOptionsBuilder withField(String fieldName, String fieldValue) {
        Objects.requireNonNull(fieldName);
        Objects.requireNonNull(fieldValue);
        this.fields.put(fieldName, fieldValue);
        return this;
    }

    public UnblockJobOptions build() {
        if (this.organizationSlug == null) {
            throw new BuilderValidationException("Organization must be provided.");
        }
        if (this.pipelineSlug == null) {
            throw new BuilderValidationException("Pipeline must be provided.");
        }
        if (this.buildNumber == null) {
            throw new BuilderValidationException("BuildNumber must be provided.");
        }
        if (this.jobId == null) {
            throw new BuilderValidationException("JobId must be provided.");
        }
        return new UnblockJobOptions(this.organizationSlug, this.pipelineSlug, this.buildNumber, this.jobId, this.unblockerUserId, this.fields);
    }
}

