/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client.request;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Map;
import java.util.Objects;
import org.sourcelab.buildkite.api.client.exception.RequestParsingException;
import org.sourcelab.buildkite.api.client.request.PutRequest;
import org.sourcelab.buildkite.api.client.request.UnblockJobOptions;
import org.sourcelab.buildkite.api.client.response.Job;
import org.sourcelab.buildkite.api.client.response.parser.GetJobResponseParser;
import org.sourcelab.buildkite.api.client.response.parser.JacksonFactory;
import org.sourcelab.buildkite.api.client.response.parser.ResponseParser;

public class UnblockJobRequest
extends PutRequest<Job> {
    private final UnblockJobOptions options;

    public UnblockJobRequest(UnblockJobOptions options) {
        this.options = Objects.requireNonNull(options);
    }

    @Override
    public String getPath() {
        return "/v2/organizations/" + this.options.getOrganizationSlug() + "/pipelines/" + this.options.getPipelineSlug() + "/builds/" + this.options.getBuildNumber() + "/jobs/" + this.options.getJobId() + "/unblock";
    }

    @Override
    public String getRequestBody() throws RequestParsingException {
        try {
            UnblockerRequestBody body = new UnblockerRequestBody(this.options.hasUnblockerUserId() ? this.options.getUnblockerUserId() : null, this.options.hasFields() ? this.options.getFields() : null);
            return JacksonFactory.newInstance().writeValueAsString((Object)body);
        }
        catch (JsonProcessingException e) {
            throw new RequestParsingException(e.getMessage(), e);
        }
    }

    @Override
    public ResponseParser<Job> getResponseParser() {
        return new GetJobResponseParser();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private static class UnblockerRequestBody {
        private String unblocker;
        private Map<String, String> fields;

        public UnblockerRequestBody(String unblocker, Map<String, String> fields) {
            this.unblocker = unblocker;
            this.fields = fields;
        }

        @JsonGetter(value="unblocker")
        public String getUnblocker() {
            return this.unblocker;
        }

        @JsonGetter(value="fields")
        public Map<String, String> getFields() {
            return this.fields;
        }
    }
}

