/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client.response;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sourcelab.buildkite.api.client.request.ListBuildsRequest;
import org.sourcelab.buildkite.api.client.request.PageableRequest;
import org.sourcelab.buildkite.api.client.response.Build;
import org.sourcelab.buildkite.api.client.response.PageableResponse;
import org.sourcelab.buildkite.api.client.response.PagingLinks;

public class ListBuildsResponse
implements PageableResponse<ListBuildsResponse> {
    private final PagingLinks pagingLinks;
    private final List<Build> builds;
    private final ListBuildsRequest originalRequest;

    public ListBuildsResponse(PagingLinks pagingLinks, List<Build> builds, ListBuildsRequest originalRequest) {
        this.pagingLinks = Objects.requireNonNull(pagingLinks);
        this.builds = Collections.unmodifiableList(new ArrayList<Build>(builds));
        this.originalRequest = originalRequest;
    }

    @Override
    public PagingLinks getPagingLinks() {
        return this.pagingLinks;
    }

    @Override
    public PageableRequest<ListBuildsResponse> getOriginalRequest() {
        return this.originalRequest;
    }

    public List<Build> getBuilds() {
        return this.builds;
    }

    public int count() {
        return this.getBuilds().size();
    }

    public List<String> getBuildIds() {
        return this.getBuilds().stream().map(Build::getId).collect(Collectors.toList());
    }

    public Optional<Build> getBuildById(String buildId) {
        Objects.requireNonNull(buildId);
        return this.getBuilds().stream().filter(build -> build.getId().equals(buildId)).findFirst();
    }

    public String toString() {
        return "ListBuildsResponse{pagingLinks=" + this.pagingLinks + ", builds=" + this.builds + ", originalRequest=" + this.originalRequest + '}';
    }
}

