/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client.response;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sourcelab.buildkite.api.client.request.ListOrganizationsRequest;
import org.sourcelab.buildkite.api.client.request.PageableRequest;
import org.sourcelab.buildkite.api.client.response.Organization;
import org.sourcelab.buildkite.api.client.response.PageableResponse;
import org.sourcelab.buildkite.api.client.response.PagingLinks;

public class ListOrganizationsResponse
implements PageableResponse<ListOrganizationsResponse> {
    private final PagingLinks pagingLinks;
    private final List<Organization> organizations;
    private final ListOrganizationsRequest originalRequest;

    public ListOrganizationsResponse(PagingLinks pagingLinks, List<Organization> organizations, ListOrganizationsRequest originalRequest) {
        this.pagingLinks = Objects.requireNonNull(pagingLinks);
        this.organizations = Collections.unmodifiableList(new ArrayList<Organization>(organizations));
        this.originalRequest = originalRequest;
    }

    @Override
    public PagingLinks getPagingLinks() {
        return this.pagingLinks;
    }

    @Override
    public PageableRequest<ListOrganizationsResponse> getOriginalRequest() {
        return this.originalRequest;
    }

    public List<Organization> getOrganizations() {
        return this.organizations;
    }

    public int count() {
        return this.getOrganizations().size();
    }

    public List<String> getOrganizationIds() {
        return this.getOrganizations().stream().map(Organization::getId).collect(Collectors.toList());
    }

    public List<String> getOrganizationNames() {
        return this.getOrganizations().stream().map(Organization::getName).sorted().collect(Collectors.toList());
    }

    public List<String> getOrganizationSlugIds() {
        return this.getOrganizations().stream().map(Organization::getSlug).sorted().collect(Collectors.toList());
    }

    public Optional<Organization> getOrganizationById(String organizationId) {
        Objects.requireNonNull(organizationId);
        return this.getOrganizations().stream().filter(organization -> organizationId.equals(organization.getId())).findFirst();
    }

    public Optional<Organization> getOrganizationByName(String organizationName) {
        Objects.requireNonNull(organizationName);
        return this.getOrganizations().stream().filter(organization -> organizationName.equals(organization.getName())).findFirst();
    }

    public Optional<Organization> getOrganizationBySlug(String slug) {
        Objects.requireNonNull(slug);
        return this.getOrganizations().stream().filter(organization -> slug.equals(organization.getSlug())).findFirst();
    }

    public String toString() {
        return "ListOrganizationsResponse{pagingLinks=" + this.pagingLinks + ", organizations=" + this.organizations + ", originalRequest=" + this.originalRequest + '}';
    }
}

