/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client.response;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sourcelab.buildkite.api.client.request.ListPipelinesRequest;
import org.sourcelab.buildkite.api.client.request.PageableRequest;
import org.sourcelab.buildkite.api.client.response.PageableResponse;
import org.sourcelab.buildkite.api.client.response.PagingLinks;
import org.sourcelab.buildkite.api.client.response.Pipeline;

public class ListPipelinesResponse
implements PageableResponse<ListPipelinesResponse> {
    private final PagingLinks pagingLinks;
    private final List<Pipeline> pipelines;
    private final ListPipelinesRequest originalRequest;

    public ListPipelinesResponse(PagingLinks pagingLinks, List<Pipeline> pipelines, ListPipelinesRequest originalRequest) {
        this.pagingLinks = Objects.requireNonNull(pagingLinks);
        this.pipelines = Collections.unmodifiableList(new ArrayList<Pipeline>(pipelines));
        this.originalRequest = originalRequest;
    }

    @Override
    public PagingLinks getPagingLinks() {
        return this.pagingLinks;
    }

    @Override
    public PageableRequest<ListPipelinesResponse> getOriginalRequest() {
        return this.originalRequest;
    }

    public List<Pipeline> getPipelines() {
        return this.pipelines;
    }

    public int count() {
        return this.getPipelines().size();
    }

    public List<String> getPipelineIds() {
        return this.getPipelines().stream().map(Pipeline::getId).collect(Collectors.toList());
    }

    public List<String> getPipelineNames() {
        return this.getPipelines().stream().map(Pipeline::getName).sorted().collect(Collectors.toList());
    }

    public List<String> getPipelineSlugIds() {
        return this.getPipelines().stream().map(Pipeline::getSlug).sorted().collect(Collectors.toList());
    }

    public Optional<Pipeline> getPipelineById(String pipelineId) {
        Objects.requireNonNull(pipelineId);
        return this.getPipelines().stream().filter(pipeline -> pipelineId.equals(pipeline.getId())).findFirst();
    }

    public Optional<Pipeline> getPipelineByName(String pipelineName) {
        Objects.requireNonNull(pipelineName);
        return this.getPipelines().stream().filter(pipeline -> pipelineName.equals(pipeline.getName())).findFirst();
    }

    public Optional<Pipeline> getPipelineBySlug(String slug) {
        Objects.requireNonNull(slug);
        return this.getPipelines().stream().filter(pipeline -> slug.equals(pipeline.getSlug())).findFirst();
    }

    public String toString() {
        return "ListPipelinesResponse{pagingLinks=" + this.pagingLinks + ", pipelines=" + this.pipelines + ", originalRequest=" + this.originalRequest + '}';
    }
}

