/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client.response;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sourcelab.buildkite.api.client.exception.BuildkiteException;
import org.sourcelab.buildkite.api.client.response.Job;

public class MultipleRetriedJobsResults {
    private final Map<String, Job> originalJobIdsMappedToUpdatedJobs;
    private final Map<String, BuildkiteException> originalJobIdsMappedToErrors;

    public MultipleRetriedJobsResults(Map<String, Job> originalJobIdsMappedToUpdatedJobs, Map<String, BuildkiteException> originalJobIdsMappedToErrors) {
        this.originalJobIdsMappedToUpdatedJobs = Collections.unmodifiableMap(new HashMap<String, Job>(originalJobIdsMappedToUpdatedJobs));
        this.originalJobIdsMappedToErrors = Collections.unmodifiableMap(new HashMap<String, BuildkiteException>(originalJobIdsMappedToErrors));
    }

    public Set<String> getOriginalJobIds() {
        HashSet<String> jobIds = new HashSet<String>(this.originalJobIdsMappedToUpdatedJobs.keySet());
        jobIds.addAll(this.originalJobIdsMappedToErrors.keySet());
        return jobIds;
    }

    public boolean hasRetriedJob(String originalJobId) {
        return this.originalJobIdsMappedToUpdatedJobs.containsKey(originalJobId);
    }

    public Job getRetriedJobByOriginalJobId(String originalJobId) {
        if (!this.hasRetriedJob(originalJobId)) {
            throw new IllegalArgumentException("Job Id " + originalJobId + " was not retried and has no result.");
        }
        return this.originalJobIdsMappedToUpdatedJobs.get(originalJobId);
    }

    public Map<String, Job> getOriginalJobIdsMappedToUpdatedJobs() {
        return this.originalJobIdsMappedToUpdatedJobs;
    }

    public List<Job> getRetriedJobs() {
        return new ArrayList<Job>(this.originalJobIdsMappedToUpdatedJobs.values());
    }

    public boolean didJobHaveError(String originalJobId) {
        return this.originalJobIdsMappedToErrors.containsKey(originalJobId);
    }

    public BuildkiteException getErrorByOriginalJobId(String originalJobId) {
        if (!this.didJobHaveError(originalJobId)) {
            throw new IllegalArgumentException("Job Id " + originalJobId + " did not have an error.");
        }
        return this.originalJobIdsMappedToErrors.get(originalJobId);
    }

    public Map<String, BuildkiteException> getOriginalJobIdsMappedToErrors() {
        return this.originalJobIdsMappedToErrors;
    }

    public List<BuildkiteException> getErrors() {
        return new ArrayList<BuildkiteException>(this.originalJobIdsMappedToErrors.values());
    }

    public String toString() {
        return "MultipleRetriedJobsResults{\n\toriginalJobIdsMappedToUpdatedJobs=" + this.originalJobIdsMappedToUpdatedJobs + "\n\toriginalJobIdsMappedToErrors=" + this.originalJobIdsMappedToErrors + "\n}";
    }
}

