/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client.response;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sourcelab.buildkite.api.client.response.PagingLinks;

public final class PagingLinksBuilder {
    private String prevUrl;
    private String nextUrl;
    private String firstUrl;
    private String lastUrl;

    public PagingLinksBuilder withPrevUrl(String prevUrl) {
        this.prevUrl = prevUrl;
        return this;
    }

    public PagingLinksBuilder withNextUrl(String nextUrl) {
        this.nextUrl = nextUrl;
        return this;
    }

    public PagingLinksBuilder withFirstUrl(String firstUrl) {
        this.firstUrl = firstUrl;
        return this;
    }

    public PagingLinksBuilder withLastUrl(String lastUrl) {
        this.lastUrl = lastUrl;
        return this;
    }

    public PagingLinksBuilder fromHeaderLine(String headerLine) {
        String[] pieces;
        Objects.requireNonNull(headerLine);
        Pattern pattern = Pattern.compile("<(.+)>; rel=\"(.+)\"");
        block12: for (String piece : pieces = headerLine.split(",")) {
            String part;
            Matcher matcher = pattern.matcher(piece.trim());
            if (!matcher.matches() || matcher.groupCount() != 2) continue;
            String url = matcher.group(1).trim();
            switch (part = matcher.group(2).trim()) {
                case "next": {
                    this.withNextUrl(url);
                    continue block12;
                }
                case "prev": {
                    this.withPrevUrl(url);
                    continue block12;
                }
                case "first": {
                    this.withFirstUrl(url);
                    continue block12;
                }
                case "last": {
                    this.withLastUrl(url);
                    continue block12;
                }
            }
        }
        return this;
    }

    public PagingLinks build() {
        return new PagingLinks(this.prevUrl, this.nextUrl, this.firstUrl, this.lastUrl);
    }
}

