/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sourcelab.buildkite.api.client.response.Provider;
import org.sourcelab.buildkite.api.client.response.Step;

public class Pipeline {
    private final String id;
    private final String graphqlId;
    private final String webUrl;
    private final String url;
    private final String name;
    private final String description;
    private final String slug;
    private final String repository;
    private final String clusterId;
    private final boolean skipQueuedBranchBuilds;
    private final boolean cancelRunningBranchBuilds;
    private final boolean allowRebuilds;
    private final String buildsUrl;
    private final String badgeUrl;
    private final ZonedDateTime createdAt;
    private final long scheduledBuildsCount;
    private final long runningBuildsCount;
    private final long scheduledJobsCount;
    private final long runningJobsCount;
    private final long waitingJobsCount;
    private final Provider provider;
    private final List<Step> steps;

    public Pipeline(@JsonProperty(value="id") String id, @JsonProperty(value="graphql_id") String graphqlId, @JsonProperty(value="web_url") String webUrl, @JsonProperty(value="url") String url, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="slug") String slug, @JsonProperty(value="repository") String repository, @JsonProperty(value="cluster_id") String clusterId, @JsonProperty(value="skip_queued_branch_builds") Boolean skipQueuedBranchBuilds, @JsonProperty(value="cancel_running_branch_builds") Boolean cancelRunningBranchBuilds, @JsonProperty(value="allow_rebuilds") Boolean allowRebuilds, @JsonProperty(value="builds_url") String buildsUrl, @JsonProperty(value="badge_url") String badgeUrl, @JsonProperty(value="created_at") ZonedDateTime createdAt, @JsonProperty(value="scheduled_builds_count") Long scheduledBuildsCount, @JsonProperty(value="running_builds_count") Long runningBuildsCount, @JsonProperty(value="scheduled_jobs_count") Long scheduledJobsCount, @JsonProperty(value="running_jobs_count") Long runningJobsCount, @JsonProperty(value="waiting_jobs_count") Long waitingJobsCount, @JsonProperty(value="provider") Provider provider, @JsonProperty(value="steps") List<Step> steps) {
        this.id = id;
        this.graphqlId = graphqlId;
        this.webUrl = webUrl;
        this.url = url;
        this.name = name;
        this.description = description;
        this.slug = slug;
        this.repository = repository;
        this.clusterId = clusterId;
        this.skipQueuedBranchBuilds = skipQueuedBranchBuilds == null ? false : skipQueuedBranchBuilds;
        this.cancelRunningBranchBuilds = cancelRunningBranchBuilds == null ? false : cancelRunningBranchBuilds;
        this.allowRebuilds = allowRebuilds == null ? false : allowRebuilds;
        this.buildsUrl = buildsUrl;
        this.badgeUrl = badgeUrl;
        this.createdAt = createdAt;
        this.scheduledBuildsCount = scheduledBuildsCount == null ? 0L : scheduledBuildsCount;
        this.runningBuildsCount = runningBuildsCount == null ? 0L : runningBuildsCount;
        this.scheduledJobsCount = scheduledJobsCount == null ? 0L : scheduledJobsCount;
        this.runningJobsCount = runningJobsCount == null ? 0L : runningJobsCount;
        this.waitingJobsCount = waitingJobsCount == null ? 0L : waitingJobsCount;
        this.provider = provider;
        ArrayList<Step> stepList = new ArrayList<Step>();
        if (steps != null) {
            stepList.addAll(steps);
        }
        this.steps = Collections.unmodifiableList(stepList);
    }

    public String getId() {
        return this.id;
    }

    public String getGraphqlId() {
        return this.graphqlId;
    }

    public String getWebUrl() {
        return this.webUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    public String getSlug() {
        return this.slug;
    }

    public String getRepository() {
        return this.repository;
    }

    public boolean isSkipQueuedBranchBuilds() {
        return this.skipQueuedBranchBuilds;
    }

    public boolean isCancelRunningBranchBuilds() {
        return this.cancelRunningBranchBuilds;
    }

    public String getBuildsUrl() {
        return this.buildsUrl;
    }

    public String getBadgeUrl() {
        return this.badgeUrl;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public long getScheduledBuildsCount() {
        return this.scheduledBuildsCount;
    }

    public long getRunningBuildsCount() {
        return this.runningBuildsCount;
    }

    public long getScheduledJobsCount() {
        return this.scheduledJobsCount;
    }

    public long getRunningJobsCount() {
        return this.runningJobsCount;
    }

    public long getWaitingJobsCount() {
        return this.waitingJobsCount;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public String getDescription() {
        return this.description;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public boolean isAllowRebuilds() {
        return this.allowRebuilds;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public String toString() {
        return "Pipeline{\n\tid='" + this.id + '\'' + "\n\tgraphqlId='" + this.graphqlId + '\'' + "\n\twebUrl='" + this.webUrl + '\'' + "\n\turl='" + this.url + '\'' + "\n\tname='" + this.name + '\'' + "\n\tdescription='" + this.description + '\'' + "\n\tslug='" + this.slug + '\'' + "\n\trepository='" + this.repository + '\'' + "\n\tclusterId='" + this.clusterId + '\'' + "\n\tskipQueuedBranchBuilds=" + this.skipQueuedBranchBuilds + "\n\tcancelRunningBranchBuilds=" + this.cancelRunningBranchBuilds + "\n\tallowRebuilds=" + this.allowRebuilds + "\n\tbuildsUrl='" + this.buildsUrl + '\'' + "\n\tbadgeUrl='" + this.badgeUrl + '\'' + "\n\tcreatedAt=" + this.createdAt + "\n\tscheduledBuildsCount=" + this.scheduledBuildsCount + "\n\trunningBuildsCount=" + this.runningBuildsCount + "\n\tscheduledJobsCount=" + this.scheduledJobsCount + "\n\trunningJobsCount=" + this.runningJobsCount + "\n\twaitingJobsCount=" + this.waitingJobsCount + "\n\tprovider=" + this.provider + "\n\tsteps=" + this.steps + "\n}";
    }
}

