/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client.response;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Step {
    private final String type;
    private final String name;
    private final String command;
    private final String artifactPaths;
    private final String branchConfiguration;
    private final Map<String, String> env;
    private final long timeoutInMinutes;
    private final List<String> agentQueryRules;

    @JsonCreator
    public Step(@JsonProperty(value="type") String type, @JsonProperty(value="name") String name, @JsonProperty(value="command") String command, @JsonProperty(value="artifact_paths") String artifactPaths, @JsonProperty(value="branch_configuration") String branchConfiguration, @JsonProperty(value="env") Map<String, String> env, @JsonProperty(value="timeout_in_minutes") Long timeoutInMinutes, @JsonProperty(value="agent_query_rules") List<String> agentQueryRules) {
        this.type = type;
        this.name = name;
        this.command = command;
        this.artifactPaths = artifactPaths;
        this.branchConfiguration = branchConfiguration;
        this.timeoutInMinutes = timeoutInMinutes == null ? -1L : timeoutInMinutes;
        HashMap<String, String> envMap = new HashMap<String, String>();
        if (env != null) {
            envMap.putAll(env);
        }
        this.env = Collections.unmodifiableMap(envMap);
        ArrayList<String> agentQueryRulesList = new ArrayList<String>();
        if (agentQueryRules != null) {
            agentQueryRulesList.addAll(agentQueryRules);
        }
        this.agentQueryRules = Collections.unmodifiableList(agentQueryRulesList);
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getCommand() {
        return this.command;
    }

    public String getArtifactPaths() {
        return this.artifactPaths;
    }

    public String getBranchConfiguration() {
        return this.branchConfiguration;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public long getTimeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public List<String> getAgentQueryRules() {
        return this.agentQueryRules;
    }

    public String toString() {
        return "Step{type='" + this.type + '\'' + ", name='" + this.name + '\'' + ", command='" + this.command + '\'' + ", artifactPaths='" + this.artifactPaths + '\'' + ", branchConfiguration='" + this.branchConfiguration + '\'' + ", env=" + this.env + ", timeoutInMinutes=" + this.timeoutInMinutes + ", agentQueryRules=" + this.agentQueryRules + '}';
    }
}

