/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.buildkite.api.client.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.sourcelab.buildkite.api.client.BuildkiteClient;
import org.sourcelab.buildkite.api.client.exception.BuildkiteException;
import org.sourcelab.buildkite.api.client.request.BuildFilters;
import org.sourcelab.buildkite.api.client.request.Filters;
import org.sourcelab.buildkite.api.client.request.GetRequest;
import org.sourcelab.buildkite.api.client.request.ListBuildsRequest;
import org.sourcelab.buildkite.api.client.request.ListOrganizationsRequest;
import org.sourcelab.buildkite.api.client.request.ListPipelinesRequest;
import org.sourcelab.buildkite.api.client.request.OrganizationFilters;
import org.sourcelab.buildkite.api.client.request.PageOptions;
import org.sourcelab.buildkite.api.client.request.PipelineFilters;
import org.sourcelab.buildkite.api.client.request.RetryJobOptions;
import org.sourcelab.buildkite.api.client.request.RetryMultipleJobsOptions;
import org.sourcelab.buildkite.api.client.response.Job;
import org.sourcelab.buildkite.api.client.response.ListBuildsResponse;
import org.sourcelab.buildkite.api.client.response.ListOrganizationsResponse;
import org.sourcelab.buildkite.api.client.response.ListPipelinesResponse;
import org.sourcelab.buildkite.api.client.response.MultipleRetriedJobsResults;
import org.sourcelab.buildkite.api.client.response.PageableResponse;

public class BuildkiteClientUtils {
    public static <REQUEST, OBJECT> List<OBJECT> retrieveAll(Filters filters, Class<REQUEST> requestClass, Class<OBJECT> objectClass, BuildkiteClient client) {
        GetRequest request;
        if (filters instanceof BuildFilters) {
            request = new ListBuildsRequest((BuildFilters)filters);
        } else if (filters instanceof OrganizationFilters) {
            request = new ListOrganizationsRequest((OrganizationFilters)filters);
        } else if (filters instanceof PipelineFilters) {
            request = new ListPipelinesRequest((PipelineFilters)filters);
        } else {
            throw new RuntimeException("Unknown type.");
        }
        ArrayList<Object> entries = new ArrayList<Object>();
        boolean hasMore = true;
        int page = 0;
        while (hasMore) {
            request.updatePageOptions(new PageOptions(++page, 100));
            PageableResponse lookupResponse = (PageableResponse)client.executeRequest(request);
            if (filters instanceof BuildFilters) {
                entries.addAll(((ListBuildsResponse)lookupResponse).getBuilds());
            } else if (filters instanceof OrganizationFilters) {
                entries.addAll(((ListOrganizationsResponse)lookupResponse).getOrganizations());
            } else if (filters instanceof PipelineFilters) {
                entries.addAll(((ListPipelinesResponse)lookupResponse).getPipelines());
            } else {
                throw new RuntimeException("Unknown type.");
            }
            hasMore = lookupResponse.getPagingLinks().hasNextUrl();
        }
        ArrayList reversed = new ArrayList(entries);
        return reversed;
    }

    public static MultipleRetriedJobsResults retryMultipleJobs(RetryMultipleJobsOptions options, BuildkiteClient client) {
        HashMap<String, Job> updatedJobs = new HashMap<String, Job>();
        HashMap<String, BuildkiteException> errors = new HashMap<String, BuildkiteException>();
        options.getJobIds().forEach(jobId -> {
            try {
                Job retriedJob = client.retryJob(RetryJobOptions.newBuilder().withJobId((String)jobId).withBuildNumber(options.getBuildNumber()).withPipelineSlug(options.getPipelineSlug()).withOrganizationSlug(options.getOrganizationSlug()).build());
                updatedJobs.put((String)jobId, retriedJob);
            }
            catch (BuildkiteException error) {
                if (options.isThrowOnError()) {
                    throw error;
                }
                errors.put((String)jobId, error);
            }
        });
        return new MultipleRetriedJobsResults(updatedJobs, errors);
    }
}

