/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.kafka.connect.apiclient;

import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourcelab.kafka.connect.apiclient.Configuration;
import org.sourcelab.kafka.connect.apiclient.exception.ResponseParseException;
import org.sourcelab.kafka.connect.apiclient.request.JacksonFactory;
import org.sourcelab.kafka.connect.apiclient.request.Request;
import org.sourcelab.kafka.connect.apiclient.request.RequestErrorResponse;
import org.sourcelab.kafka.connect.apiclient.request.delete.DeleteConnector;
import org.sourcelab.kafka.connect.apiclient.request.dto.ConnectServerVersion;
import org.sourcelab.kafka.connect.apiclient.request.dto.ConnectorDefinition;
import org.sourcelab.kafka.connect.apiclient.request.dto.ConnectorPlugin;
import org.sourcelab.kafka.connect.apiclient.request.dto.ConnectorPluginConfigDefinition;
import org.sourcelab.kafka.connect.apiclient.request.dto.ConnectorPluginConfigValidationResults;
import org.sourcelab.kafka.connect.apiclient.request.dto.ConnectorStatus;
import org.sourcelab.kafka.connect.apiclient.request.dto.ConnectorTopics;
import org.sourcelab.kafka.connect.apiclient.request.dto.ConnectorsWithExpandedInfo;
import org.sourcelab.kafka.connect.apiclient.request.dto.ConnectorsWithExpandedMetadata;
import org.sourcelab.kafka.connect.apiclient.request.dto.ConnectorsWithExpandedStatus;
import org.sourcelab.kafka.connect.apiclient.request.dto.NewConnectorDefinition;
import org.sourcelab.kafka.connect.apiclient.request.dto.Task;
import org.sourcelab.kafka.connect.apiclient.request.dto.TaskStatus;
import org.sourcelab.kafka.connect.apiclient.request.get.GetConnectServerVersion;
import org.sourcelab.kafka.connect.apiclient.request.get.GetConnector;
import org.sourcelab.kafka.connect.apiclient.request.get.GetConnectorConfig;
import org.sourcelab.kafka.connect.apiclient.request.get.GetConnectorPlugins;
import org.sourcelab.kafka.connect.apiclient.request.get.GetConnectorStatus;
import org.sourcelab.kafka.connect.apiclient.request.get.GetConnectorTaskStatus;
import org.sourcelab.kafka.connect.apiclient.request.get.GetConnectorTasks;
import org.sourcelab.kafka.connect.apiclient.request.get.GetConnectorTopics;
import org.sourcelab.kafka.connect.apiclient.request.get.GetConnectors;
import org.sourcelab.kafka.connect.apiclient.request.get.GetConnectorsExpandAllDetails;
import org.sourcelab.kafka.connect.apiclient.request.get.GetConnectorsExpandInfo;
import org.sourcelab.kafka.connect.apiclient.request.get.GetConnectorsExpandStatus;
import org.sourcelab.kafka.connect.apiclient.request.post.PostConnector;
import org.sourcelab.kafka.connect.apiclient.request.post.PostConnectorRestart;
import org.sourcelab.kafka.connect.apiclient.request.post.PostConnectorTaskRestart;
import org.sourcelab.kafka.connect.apiclient.request.put.PutConnectorConfig;
import org.sourcelab.kafka.connect.apiclient.request.put.PutConnectorPause;
import org.sourcelab.kafka.connect.apiclient.request.put.PutConnectorPluginConfigValidate;
import org.sourcelab.kafka.connect.apiclient.request.put.PutConnectorResume;
import org.sourcelab.kafka.connect.apiclient.request.put.PutConnectorTopicsReset;
import org.sourcelab.kafka.connect.apiclient.rest.HttpClientRestClient;
import org.sourcelab.kafka.connect.apiclient.rest.RestClient;
import org.sourcelab.kafka.connect.apiclient.rest.RestResponse;
import org.sourcelab.kafka.connect.apiclient.rest.exceptions.InvalidRequestException;
import org.sourcelab.kafka.connect.apiclient.rest.exceptions.UnauthorizedRequestException;

public class KafkaConnectClient {
    private static final Logger logger = LoggerFactory.getLogger(KafkaConnectClient.class);
    private final Configuration configuration;
    private final RestClient restClient;
    private boolean isInitialized = false;

    public KafkaConnectClient(Configuration configuration) {
        this.configuration = configuration;
        this.restClient = new HttpClientRestClient();
    }

    public KafkaConnectClient(Configuration configuration, RestClient restClient) {
        this.configuration = configuration;
        this.restClient = restClient;
    }

    public ConnectServerVersion getConnectServerVersion() {
        return this.submitRequest(new GetConnectServerVersion());
    }

    public Collection<String> getConnectors() {
        return this.submitRequest(new GetConnectors());
    }

    public ConnectorsWithExpandedStatus getConnectorsWithExpandedStatus() {
        return this.submitRequest(new GetConnectorsExpandStatus());
    }

    public ConnectorsWithExpandedInfo getConnectorsWithExpandedInfo() {
        return this.submitRequest(new GetConnectorsExpandInfo());
    }

    public ConnectorsWithExpandedMetadata getConnectorsWithAllExpandedMetadata() {
        return this.submitRequest(new GetConnectorsExpandAllDetails());
    }

    public ConnectorDefinition getConnector(String connectorName) {
        return this.submitRequest(new GetConnector(connectorName));
    }

    public Map<String, String> getConnectorConfig(String connectorName) {
        return this.submitRequest(new GetConnectorConfig(connectorName));
    }

    public ConnectorStatus getConnectorStatus(String connectorName) {
        return this.submitRequest(new GetConnectorStatus(connectorName));
    }

    public ConnectorTopics getConnectorTopics(String connectorName) {
        return this.submitRequest(new GetConnectorTopics(connectorName));
    }

    public boolean resetConnectorTopics(String connectorName) {
        return this.submitRequest(new PutConnectorTopicsReset(connectorName));
    }

    public ConnectorDefinition addConnector(NewConnectorDefinition connectorDefinition) {
        return this.submitRequest(new PostConnector(connectorDefinition));
    }

    public ConnectorDefinition updateConnectorConfig(String connectorName, Map<String, String> config) {
        return this.submitRequest(new PutConnectorConfig(connectorName, config));
    }

    public Boolean restartConnector(String connectorName) {
        return this.submitRequest(new PostConnectorRestart(connectorName));
    }

    public Boolean pauseConnector(String connectorName) {
        return this.submitRequest(new PutConnectorPause(connectorName));
    }

    public Boolean resumeConnector(String connectorName) {
        return this.submitRequest(new PutConnectorResume(connectorName));
    }

    public Boolean deleteConnector(String connectorName) {
        return this.submitRequest(new DeleteConnector(connectorName));
    }

    public Collection<Task> getConnectorTasks(String connectorName) {
        return this.submitRequest(new GetConnectorTasks(connectorName));
    }

    public TaskStatus getConnectorTaskStatus(String connectorName, int taskId) {
        return this.submitRequest(new GetConnectorTaskStatus(connectorName, taskId));
    }

    public Boolean restartConnectorTask(String connectorName, int taskId) {
        return this.submitRequest(new PostConnectorTaskRestart(connectorName, taskId));
    }

    public Collection<ConnectorPlugin> getConnectorPlugins() {
        return this.submitRequest(new GetConnectorPlugins());
    }

    public ConnectorPluginConfigValidationResults validateConnectorPluginConfig(ConnectorPluginConfigDefinition configDefinition) {
        return this.submitRequest(new PutConnectorPluginConfigValidate(configDefinition.getName(), configDefinition.getConfig()));
    }

    private <T> T submitRequest(Request<T> request) {
        RestResponse restResponse = this.getRestClient().submitRequest(request);
        int responseCode = restResponse.getHttpCode();
        String responseStr = restResponse.getResponseStr();
        logger.debug("Response: {}", (Object)restResponse);
        if (responseCode >= 200 && responseCode < 300) {
            if ((responseCode == 204 || responseCode == 205) && responseStr == null) {
                responseStr = "";
            }
            try {
                return request.parseResponse(responseStr);
            }
            catch (MismatchedInputException exception) {
                throw new ResponseParseException(exception.getMessage(), exception);
            }
            catch (IOException exception) {
                throw new RuntimeException(exception.getMessage(), exception);
            }
        }
        if (responseCode == 401) {
            String errorMsg = this.configuration.getBasicAuthUsername() == null ? "Server required authentication credentials but none were provided in client configuration." : "Client authentication credentials (username=" + this.configuration.getBasicAuthUsername() + ") was rejected by server.";
            errorMsg = errorMsg + " Server responded with: \"" + responseStr + "\"";
            throw new UnauthorizedRequestException(errorMsg, responseCode);
        }
        try {
            RequestErrorResponse errorResponse = (RequestErrorResponse)JacksonFactory.newInstance().readValue(responseStr, RequestErrorResponse.class);
            throw InvalidRequestException.factory(errorResponse);
        }
        catch (IOException iOException) {
            throw new InvalidRequestException("Invalid response from server: " + responseStr, restResponse.getHttpCode());
        }
    }

    private RestClient getRestClient() {
        if (!this.isInitialized) {
            this.restClient.init(this.getConfiguration());
            this.isInitialized = true;
        }
        return this.restClient;
    }

    private Configuration getConfiguration() {
        return this.configuration;
    }
}

