/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.kafka.connect.apiclient.request.get;

import com.google.common.net.UrlEscapers;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.sourcelab.kafka.connect.apiclient.request.JacksonFactory;
import org.sourcelab.kafka.connect.apiclient.request.dto.Task;
import org.sourcelab.kafka.connect.apiclient.request.get.GetRequest;

public final class GetConnectorTasks
implements GetRequest<Collection<Task>> {
    private final String connectorName;

    public GetConnectorTasks(String connectorName) {
        Objects.requireNonNull(connectorName);
        this.connectorName = connectorName;
    }

    @Override
    public String getApiEndpoint() {
        return "/connectors/" + UrlEscapers.urlPathSegmentEscaper().escape(this.connectorName) + "/tasks";
    }

    @Override
    public Collection<Task> parseResponse(String responseStr) throws IOException {
        return Arrays.asList((Task[])JacksonFactory.newInstance().readValue(responseStr, Task[].class));
    }
}

