/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.kafka.connect.apiclient.request.dto;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonDeserialize(using=Deserializer.class)
public class ConnectorTopics {
    private final String name;
    private final List<String> topics;

    public ConnectorTopics(String name, List<String> topics) {
        this.name = Objects.requireNonNull(name);
        Objects.requireNonNull(topics);
        this.topics = Collections.unmodifiableList(topics.stream().sorted().collect(Collectors.toList()));
    }

    public String getName() {
        return this.name;
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public String toString() {
        return "ConnectorTopics{name='" + this.name + '\'' + ", topics=" + this.topics + '}';
    }

    public static class Deserializer
    extends StdDeserializer<ConnectorTopics> {
        public Deserializer() {
            this(null);
        }

        public Deserializer(Class<?> vc) {
            super(vc);
        }

        public ConnectorTopics deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            Iterator children = node.fields();
            while (children.hasNext()) {
                Map.Entry child = (Map.Entry)children.next();
                String name = (String)child.getKey();
                JsonNode childNode = (JsonNode)child.getValue();
                if (JsonNodeType.OBJECT != childNode.getNodeType() || !childNode.has("topics") || JsonNodeType.ARRAY != childNode.get("topics").getNodeType()) continue;
                ArrayList<String> topicNames = new ArrayList<String>();
                if (!childNode.get("topics").isEmpty()) {
                    childNode.get("topics").forEach(entry -> topicNames.add(entry.textValue()));
                }
                return new ConnectorTopics(name, topicNames);
            }
            throw new JsonParseException(jsonParser, "Unable to parse response JSON");
        }
    }
}

