/**
 * Copyright 2018, 2019, 2020, 2021 SourceLab.org https://github.com/SourceLabOrg/kafka-connect-client
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit
 * persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package org.sourcelab.kafka.connect.apiclient.request.dto;

import java.util.HashMap;
import java.util.Map;

/**
 * Represents Details about a Task.
 */
public final class Task {
    private TaskId id;
    private Map<String, String> config;

    /**
     * Default constructor.
     */
    public Task() {
    }

    /**
     * Constructor.
     */
    public Task(final TaskId id, final Map<String, String> config)
    {
        this.id = id;
        this.config = new HashMap<>(config);
    }

    public TaskId getId() {
        return id;
    }

    public Map<String, String> getConfig() {
        return config;
    }

    @Override
    public String toString() {
        return "Task{"
            + "id=" + id
            + ", config=" + config
            + '}';
    }

    /**
     * Defines a Task Id.
     */
    public static class TaskId {
        private String connector;
        private int task;

        /**
         * Default constructor.
         */
        public TaskId()
        {
        }

        /**
         * Constructor.
         */
        public TaskId(final String connector, final int task) {
            this.connector = connector;
            this.task = task;
        }

        public String getConnector() {
            return connector;
        }

        public int getTask() {
            return task;
        }

        @Override
        public String toString() {
            return "TaskId{"
                + "connector='" + connector + '\''
                + ", task=" + task
                + '}';
        }
    }

}
