/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.kafka.connect.apiclient.request.dto;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class NewConnectorDefinition {
    private final String name;
    private final Map<String, String> config;

    public static Builder newBuilder() {
        return new Builder();
    }

    public NewConnectorDefinition(String name, Map<String, String> config) {
        this.name = name;
        this.config = Collections.unmodifiableMap(new HashMap<String, String>(config));
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public String toString() {
        return "NewConnectorDefinition{name='" + this.name + '\'' + ", config=" + this.config + '}';
    }

    public static final class Builder {
        private String name;
        private Map<String, String> config = new HashMap<String, String>();

        private Builder() {
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withConfig(Map<String, String> config) {
            this.config = new HashMap<String, String>(config);
            return this;
        }

        public Builder withConfig(String key, String value) {
            this.config.put(key, value);
            return this;
        }

        public Builder withConfig(String key, Object value) {
            this.config.put(key, value.toString());
            return this;
        }

        public NewConnectorDefinition build() {
            return new NewConnectorDefinition(this.name, this.config);
        }
    }
}

