/*
 * Decompiled with CFR 0.152.
 */
package akka.jsr166y;

import java.util.Random;

public class ThreadLocalRandom
extends Random {
    private static final long multiplier = 25214903917L;
    private static final long addend = 11L;
    private static final long mask = 0xFFFFFFFFFFFFL;
    private long rnd;
    boolean initialized = true;
    private long pad0;
    private long pad1;
    private long pad2;
    private long pad3;
    private long pad4;
    private long pad5;
    private long pad6;
    private long pad7;
    private static final ThreadLocal<ThreadLocalRandom> localRandom = new ThreadLocal<ThreadLocalRandom>(){

        @Override
        protected ThreadLocalRandom initialValue() {
            return new ThreadLocalRandom();
        }
    };
    private static final long serialVersionUID = -5851777807851030925L;

    ThreadLocalRandom() {
    }

    public static ThreadLocalRandom current() {
        return localRandom.get();
    }

    public void setSeed(long l) {
        if (this.initialized) {
            throw new UnsupportedOperationException();
        }
        this.rnd = (l ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    protected int next(int n) {
        this.rnd = this.rnd * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(this.rnd >>> 48 - n);
    }

    public int nextInt(int n, int n2) {
        if (n >= n2) {
            throw new IllegalArgumentException();
        }
        return this.nextInt(n2 - n) + n;
    }

    public long nextLong(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("n must be positive");
        }
        long l2 = 0L;
        while (l >= Integer.MAX_VALUE) {
            long l3;
            int n = this.next(2);
            long l4 = l >>> 1;
            long l5 = l3 = (n & 2) == 0 ? l4 : l - l4;
            if ((n & 1) == 0) {
                l2 += l - l3;
            }
            l = l3;
        }
        return l2 + (long)this.nextInt((int)l);
    }

    public long nextLong(long l, long l2) {
        if (l >= l2) {
            throw new IllegalArgumentException();
        }
        return this.nextLong(l2 - l) + l;
    }

    public double nextDouble(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("n must be positive");
        }
        return this.nextDouble() * d;
    }

    public double nextDouble(double d, double d2) {
        if (d >= d2) {
            throw new IllegalArgumentException();
        }
        return this.nextDouble() * (d2 - d) + d;
    }
}

