/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.akka.util.internal;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.netty.akka.util.internal.ReusableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConcurrentIdentityHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    final int segmentMask;
    final int segmentShift;
    final Segment<K, V>[] segments;
    Set<K> keySet;
    Set<Map.Entry<K, V>> entrySet;
    Collection<V> values;

    private static int hash(int n) {
        n += n << 15 ^ 0xFFFFCD7D;
        n ^= n >>> 10;
        n += n << 3;
        n ^= n >>> 6;
        n += (n << 2) + (n << 14);
        return n ^ n >>> 16;
    }

    final Segment<K, V> segmentFor(int n) {
        return this.segments[n >>> this.segmentShift & this.segmentMask];
    }

    private int hashOf(Object object) {
        return ConcurrentIdentityHashMap.hash(System.identityHashCode(object));
    }

    public ConcurrentIdentityHashMap(int n, float f, int n2) {
        int n3;
        int n4;
        int n5;
        if (!(f > 0.0f) || n < 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        if (n2 > 65536) {
            n2 = 65536;
        }
        int n6 = 0;
        for (n5 = 1; n5 < n2; n5 <<= 1) {
            ++n6;
        }
        this.segmentShift = 32 - n6;
        this.segmentMask = n5 - 1;
        this.segments = Segment.newArray(n5);
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if ((n4 = n / n5) * n5 < n) {
            ++n4;
        }
        for (n3 = 1; n3 < n4; n3 <<= 1) {
        }
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment(n3, f);
        }
    }

    public ConcurrentIdentityHashMap(int n, float f) {
        this(n, f, 16);
    }

    public ConcurrentIdentityHashMap(int n) {
        this(n, 0.75f, 16);
    }

    public ConcurrentIdentityHashMap() {
        this(16, 0.75f, 16);
    }

    public ConcurrentIdentityHashMap(Map<? extends K, ? extends V> map2) {
        this(Math.max((int)((float)map2.size() / 0.75f) + 1, 16), 0.75f, 16);
        this.putAll(map2);
    }

    @Override
    public boolean isEmpty() {
        int n;
        Segment<K, V>[] segmentArray = this.segments;
        int[] nArray = new int[segmentArray.length];
        int n2 = 0;
        for (n = 0; n < segmentArray.length; ++n) {
            if (segmentArray[n].count != 0) {
                return false;
            }
            nArray[n] = segmentArray[n].modCount;
            n2 += nArray[n];
        }
        if (n2 != 0) {
            for (n = 0; n < segmentArray.length; ++n) {
                if (segmentArray[n].count == 0 && nArray[n] == segmentArray[n].modCount) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int size() {
        int n;
        Segment<K, V>[] segmentArray = this.segments;
        long l = 0L;
        long l2 = 0L;
        int[] nArray = new int[segmentArray.length];
        for (n = 0; n < 2; ++n) {
            int n2;
            l2 = 0L;
            l = 0L;
            int n3 = 0;
            for (n2 = 0; n2 < segmentArray.length; ++n2) {
                l += (long)segmentArray[n2].count;
                nArray[n2] = segmentArray[n2].modCount;
                n3 += nArray[n2];
            }
            if (n3 != 0) {
                for (n2 = 0; n2 < segmentArray.length; ++n2) {
                    l2 += (long)segmentArray[n2].count;
                    if (nArray[n2] == segmentArray[n2].modCount) continue;
                    l2 = -1L;
                    break;
                }
            }
            if (l2 == l) break;
        }
        if (l2 != l) {
            l = 0L;
            for (n = 0; n < segmentArray.length; ++n) {
                segmentArray[n].lock();
            }
            for (n = 0; n < segmentArray.length; ++n) {
                l += (long)segmentArray[n].count;
            }
            for (n = 0; n < segmentArray.length; ++n) {
                segmentArray[n].unlock();
            }
        }
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    @Override
    public V get(Object object) {
        int n = this.hashOf(object);
        return this.segmentFor(n).get(object, n);
    }

    @Override
    public boolean containsKey(Object object) {
        int n = this.hashOf(object);
        return this.segmentFor(n).containsKey(object, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object object) {
        int n;
        boolean bl;
        if (object == null) {
            throw new NullPointerException();
        }
        Segment<K, V>[] segmentArray = this.segments;
        int[] nArray = new int[segmentArray.length];
        for (bl = false; bl < 2 != 0; bl += 1) {
            int n2;
            n = 0;
            for (n2 = 0; n2 < segmentArray.length; ++n2) {
                nArray[n2] = segmentArray[n2].modCount;
                n += nArray[n2];
                if (!segmentArray[n2].containsValue(object)) continue;
                return true;
            }
            n2 = 1;
            if (n != 0) {
                for (int i = 0; i < segmentArray.length; ++i) {
                    if (nArray[i] == segmentArray[i].modCount) continue;
                    n2 = 0;
                    break;
                }
            }
            if (n2 == 0) continue;
            return false;
        }
        for (bl = false; bl < segmentArray.length; bl += 1) {
            segmentArray[bl].lock();
        }
        bl = false;
        try {
            for (n = 0; n < segmentArray.length; ++n) {
                if (!segmentArray[n].containsValue(object)) continue;
                bl = true;
                break;
            }
        }
        finally {
            for (n = 0; n < segmentArray.length; ++n) {
                segmentArray[n].unlock();
            }
        }
        return bl;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    @Override
    public V put(K k, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        int n = this.hashOf(k);
        return this.segmentFor(n).put(k, n, v, false);
    }

    @Override
    public V putIfAbsent(K k, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        int n = this.hashOf(k);
        return this.segmentFor(n).put(k, n, v, true);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map2) {
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        int n = this.hashOf(object);
        return this.segmentFor(n).remove(object, n, null, false);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        int n = this.hashOf(object);
        if (object2 == null) {
            return false;
        }
        return this.segmentFor(n).remove(object, n, object2, false) != null;
    }

    @Override
    public boolean replace(K k, V v, V v2) {
        if (v == null || v2 == null) {
            throw new NullPointerException();
        }
        int n = this.hashOf(k);
        return this.segmentFor(n).replace(k, n, v, v2);
    }

    @Override
    public V replace(K k, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        int n = this.hashOf(k);
        return this.segmentFor(n).replace(k, n, v);
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].clear();
        }
    }

    @Override
    public Set<K> keySet() {
        KeySet keySet = this.keySet;
        return keySet != null ? keySet : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values values2 = this.values;
        return values2 != null ? values2 : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet());
    }

    public Enumeration<K> keys() {
        return new KeyIterator();
    }

    public Enumeration<V> elements() {
        return new ValueIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object v = ConcurrentIdentityHashMap.this.get(entry.getKey());
            return v != null && v.equals(entry.getValue());
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return ConcurrentIdentityHashMap.this.remove(entry.getKey(), entry.getValue());
        }

        @Override
        public int size() {
            return ConcurrentIdentityHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentIdentityHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            ConcurrentIdentityHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return ConcurrentIdentityHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentIdentityHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return ConcurrentIdentityHashMap.this.containsValue(object);
        }

        @Override
        public void clear() {
            ConcurrentIdentityHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return ConcurrentIdentityHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentIdentityHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return ConcurrentIdentityHashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return ConcurrentIdentityHashMap.this.remove(object) != null;
        }

        @Override
        public void clear() {
            ConcurrentIdentityHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class EntryIterator
    extends HashIterator
    implements ReusableIterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            HashEntry hashEntry = super.nextEntry();
            return new WriteThroughEntry(hashEntry.key(), hashEntry.value());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class WriteThroughEntry
    extends SimpleEntry<K, V> {
        WriteThroughEntry(K k, V v) {
            super(k, v);
        }

        @Override
        public V setValue(V v) {
            if (v == null) {
                throw new NullPointerException();
            }
            Object v2 = super.setValue(v);
            ConcurrentIdentityHashMap.this.put(this.getKey(), v);
            return v2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        private static final long serialVersionUID = -8144765946475398746L;
        private final K key;
        private V value;

        public SimpleEntry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        public SimpleEntry(Map.Entry<? extends K, ? extends V> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return SimpleEntry.eq(this.key, entry.getKey()) && SimpleEntry.eq(this.value, entry.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private static boolean eq(Object object, Object object2) {
            return object == null ? object2 == null : object.equals(object2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ValueIterator
    extends HashIterator
    implements ReusableIterator<V>,
    Enumeration<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            return super.nextEntry().value();
        }

        @Override
        public V nextElement() {
            return super.nextEntry().value();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class KeyIterator
    extends HashIterator
    implements ReusableIterator<K>,
    Enumeration<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            return super.nextEntry().key();
        }

        @Override
        public K nextElement() {
            return super.nextEntry().key();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        HashEntry<K, V>[] currentTable;
        HashEntry<K, V> nextEntry;
        HashEntry<K, V> lastReturned;
        K currentKey;

        HashIterator() {
            this.nextSegmentIndex = ConcurrentIdentityHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        public void rewind() {
            this.nextSegmentIndex = ConcurrentIdentityHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.currentTable = null;
            this.nextEntry = null;
            this.lastReturned = null;
            this.currentKey = null;
            this.advance();
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        final void advance() {
            if (this.nextEntry != null && (this.nextEntry = this.nextEntry.next) != null) {
                return;
            }
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable[this.nextTableIndex--]) == null) continue;
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                Segment segment = ConcurrentIdentityHashMap.this.segments[this.nextSegmentIndex--];
                if (segment.count == 0) continue;
                this.currentTable = segment.table;
                for (int i = this.currentTable.length - 1; i >= 0; --i) {
                    this.nextEntry = this.currentTable[i];
                    if (this.nextEntry == null) continue;
                    this.nextTableIndex = i - 1;
                    return;
                }
            }
        }

        public boolean hasNext() {
            while (this.nextEntry != null) {
                if (this.nextEntry.key() != null) {
                    return true;
                }
                this.advance();
            }
            return false;
        }

        HashEntry<K, V> nextEntry() {
            do {
                if (this.nextEntry == null) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.nextEntry;
                this.currentKey = this.lastReturned.key();
                this.advance();
            } while (this.currentKey == null);
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentIdentityHashMap.this.remove(this.currentKey);
            this.lastReturned = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Segment<K, V>
    extends ReentrantLock {
        private static final long serialVersionUID = 5207829234977119743L;
        volatile transient int count;
        int modCount;
        int threshold;
        volatile transient HashEntry<K, V>[] table;
        final float loadFactor;

        Segment(int n, float f) {
            this.loadFactor = f;
            this.setTable(HashEntry.newArray(n));
        }

        static final <K, V> Segment<K, V>[] newArray(int n) {
            return new Segment[n];
        }

        private boolean keyEq(Object object, Object object2) {
            return object == object2;
        }

        void setTable(HashEntry<K, V>[] hashEntryArray) {
            this.threshold = (int)((float)hashEntryArray.length * this.loadFactor);
            this.table = hashEntryArray;
        }

        HashEntry<K, V> getFirst(int n) {
            HashEntry<K, V>[] hashEntryArray = this.table;
            return hashEntryArray[n & hashEntryArray.length - 1];
        }

        HashEntry<K, V> newHashEntry(K k, int n, HashEntry<K, V> hashEntry, V v) {
            return new HashEntry<K, V>(k, n, hashEntry, v);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V readValueUnderLock(HashEntry<K, V> hashEntry) {
            this.lock();
            try {
                V v = hashEntry.value();
                return v;
            }
            finally {
                this.unlock();
            }
        }

        V get(Object object, int n) {
            if (this.count != 0) {
                HashEntry<K, V> hashEntry = this.getFirst(n);
                while (hashEntry != null) {
                    if (hashEntry.hash == n && this.keyEq(object, hashEntry.key())) {
                        V v = hashEntry.value();
                        if (v != null) {
                            return v;
                        }
                        return this.readValueUnderLock(hashEntry);
                    }
                    hashEntry = hashEntry.next;
                }
            }
            return null;
        }

        boolean containsKey(Object object, int n) {
            if (this.count != 0) {
                HashEntry<K, V> hashEntry = this.getFirst(n);
                while (hashEntry != null) {
                    if (hashEntry.hash == n && this.keyEq(object, hashEntry.key())) {
                        return true;
                    }
                    hashEntry = hashEntry.next;
                }
            }
            return false;
        }

        boolean containsValue(Object object) {
            if (this.count != 0) {
                for (HashEntry<K, V> hashEntry : this.table) {
                    while (hashEntry != null) {
                        V v = hashEntry.value();
                        V v2 = v == null ? this.readValueUnderLock(hashEntry) : v;
                        if (object.equals(v2)) {
                            return true;
                        }
                        hashEntry = hashEntry.next;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean replace(K k, int n, V v, V v2) {
            this.lock();
            try {
                HashEntry<K, V> hashEntry = this.getFirst(n);
                while (!(hashEntry == null || hashEntry.hash == n && this.keyEq(k, hashEntry.key()))) {
                    hashEntry = hashEntry.next;
                }
                boolean bl = false;
                if (hashEntry != null && v.equals(hashEntry.value())) {
                    bl = true;
                    hashEntry.setValue(v2);
                }
                boolean bl2 = bl;
                return bl2;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V replace(K k, int n, V v) {
            this.lock();
            try {
                HashEntry<K, V> hashEntry = this.getFirst(n);
                while (!(hashEntry == null || hashEntry.hash == n && this.keyEq(k, hashEntry.key()))) {
                    hashEntry = hashEntry.next;
                }
                V v2 = null;
                if (hashEntry != null) {
                    v2 = hashEntry.value();
                    hashEntry.setValue(v);
                }
                V v3 = v2;
                return v3;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(K k, int n, V v, boolean bl) {
            this.lock();
            try {
                V v2;
                HashEntry<K, V> hashEntry;
                int n2;
                int n3 = this.count;
                if (n3++ > this.threshold && (n2 = this.rehash()) > 0) {
                    this.count = (n3 -= n2) - 1;
                }
                HashEntry<K, V>[] hashEntryArray = this.table;
                int n4 = n & hashEntryArray.length - 1;
                HashEntry<K, V> hashEntry2 = hashEntry = hashEntryArray[n4];
                while (!(hashEntry2 == null || hashEntry2.hash == n && this.keyEq(k, hashEntry2.key()))) {
                    hashEntry2 = hashEntry2.next;
                }
                if (hashEntry2 != null) {
                    v2 = hashEntry2.value();
                    if (!bl) {
                        hashEntry2.setValue(v);
                    }
                } else {
                    v2 = null;
                    ++this.modCount;
                    hashEntryArray[n4] = this.newHashEntry(k, n, hashEntry, v);
                    this.count = n3;
                }
                V v3 = v2;
                return v3;
            }
            finally {
                this.unlock();
            }
        }

        int rehash() {
            HashEntry<K, V>[] hashEntryArray = this.table;
            int n = hashEntryArray.length;
            if (n >= 0x40000000) {
                return 0;
            }
            HashEntry<K, V>[] hashEntryArray2 = HashEntry.newArray(n << 1);
            this.threshold = (int)((float)hashEntryArray2.length * this.loadFactor);
            int n2 = hashEntryArray2.length - 1;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                HashEntry<K, V> hashEntry = hashEntryArray[i];
                if (hashEntry == null) continue;
                HashEntry hashEntry2 = hashEntry.next;
                int n4 = hashEntry.hash & n2;
                if (hashEntry2 == null) {
                    hashEntryArray2[n4] = hashEntry;
                    continue;
                }
                HashEntry<K, V> hashEntry3 = hashEntry;
                int n5 = n4;
                HashEntry hashEntry4 = hashEntry2;
                while (hashEntry4 != null) {
                    int n6 = hashEntry4.hash & n2;
                    if (n6 != n5) {
                        n5 = n6;
                        hashEntry3 = hashEntry4;
                    }
                    hashEntry4 = hashEntry4.next;
                }
                hashEntryArray2[n5] = hashEntry3;
                hashEntry4 = hashEntry;
                while (hashEntry4 != hashEntry3) {
                    Object k = hashEntry4.key();
                    if (k == null) {
                        ++n3;
                    } else {
                        int n7 = hashEntry4.hash & n2;
                        HashEntry hashEntry5 = hashEntryArray2[n7];
                        hashEntryArray2[n7] = this.newHashEntry(k, hashEntry4.hash, hashEntry5, hashEntry4.value());
                    }
                    hashEntry4 = hashEntry4.next;
                }
            }
            this.table = hashEntryArray2;
            return n3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V remove(Object object, int n, Object object2, boolean bl) {
            this.lock();
            try {
                V v;
                HashEntry<K, V> hashEntry;
                int n2 = this.count - 1;
                HashEntry<K, V>[] hashEntryArray = this.table;
                int n3 = n & hashEntryArray.length - 1;
                HashEntry<K, V> hashEntry2 = hashEntry = hashEntryArray[n3];
                while (hashEntry2 != null && object != hashEntry2.key && (bl || n != hashEntry2.hash || !this.keyEq(object, hashEntry2.key()))) {
                    hashEntry2 = hashEntry2.next;
                }
                V v2 = null;
                if (hashEntry2 != null) {
                    v = hashEntry2.value();
                    if (object2 == null || object2.equals(v)) {
                        v2 = v;
                        ++this.modCount;
                        HashEntry hashEntry3 = hashEntry2.next;
                        HashEntry<K, V> hashEntry4 = hashEntry;
                        while (hashEntry4 != hashEntry2) {
                            K k = hashEntry4.key();
                            if (k == null) {
                                --n2;
                            } else {
                                hashEntry3 = this.newHashEntry(k, hashEntry4.hash, hashEntry3, hashEntry4.value());
                            }
                            hashEntry4 = hashEntry4.next;
                        }
                        hashEntryArray[n3] = hashEntry3;
                        this.count = n2;
                    }
                }
                v = v2;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            if (this.count != 0) {
                this.lock();
                try {
                    HashEntry<K, V>[] hashEntryArray = this.table;
                    for (int i = 0; i < hashEntryArray.length; ++i) {
                        hashEntryArray[i] = null;
                    }
                    ++this.modCount;
                    this.count = 0;
                }
                finally {
                    this.unlock();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class HashEntry<K, V> {
        final Object key;
        final int hash;
        volatile Object value;
        final HashEntry<K, V> next;

        HashEntry(K k, int n, HashEntry<K, V> hashEntry, V v) {
            this.hash = n;
            this.next = hashEntry;
            this.key = k;
            this.value = v;
        }

        final K key() {
            return (K)this.key;
        }

        final V value() {
            return (V)this.value;
        }

        final void setValue(V v) {
            this.value = v;
        }

        static final <K, V> HashEntry<K, V>[] newArray(int n) {
            return new HashEntry[n];
        }
    }
}

