/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.OrcUnion;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ParameterizedPrimitiveTypeUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeParams;
import org.apache.hadoop.io.Writable;

final class OrcStruct
implements Writable {
    private Object[] fields;

    OrcStruct(int children) {
        this.fields = new Object[children];
    }

    Object getFieldValue(int fieldIndex) {
        return this.fields[fieldIndex];
    }

    void setFieldValue(int fieldIndex, Object value) {
        this.fields[fieldIndex] = value;
    }

    public int getNumFields() {
        return this.fields.length;
    }

    public void setNumFields(int numFields) {
        if (this.fields.length != numFields) {
            Object[] oldFields = this.fields;
            this.fields = new Object[numFields];
            System.arraycopy(oldFields, 0, this.fields, 0, Math.min(oldFields.length, numFields));
        }
    }

    public void write(DataOutput dataOutput) throws IOException {
        throw new UnsupportedOperationException("write unsupported");
    }

    public void readFields(DataInput dataInput) throws IOException {
        throw new UnsupportedOperationException("readFields unsupported");
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != OrcStruct.class) {
            return false;
        }
        OrcStruct oth = (OrcStruct)other;
        if (this.fields.length != oth.fields.length) {
            return false;
        }
        for (int i = 0; i < this.fields.length; ++i) {
            if (!(this.fields[i] == null ? oth.fields[i] != null : !this.fields[i].equals(oth.fields[i]))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.fields.length;
        for (Object field : this.fields) {
            if (field == null) continue;
            result ^= field.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{");
        for (int i = 0; i < this.fields.length; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.fields[i]);
        }
        buffer.append("}");
        return buffer.toString();
    }

    static ObjectInspector createObjectInspector(TypeInfo info) {
        switch (info.getCategory()) {
            case PRIMITIVE: {
                switch (((PrimitiveTypeInfo)info).getPrimitiveCategory()) {
                    case FLOAT: {
                        return PrimitiveObjectInspectorFactory.writableFloatObjectInspector;
                    }
                    case DOUBLE: {
                        return PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
                    }
                    case BOOLEAN: {
                        return PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
                    }
                    case BYTE: {
                        return PrimitiveObjectInspectorFactory.writableByteObjectInspector;
                    }
                    case SHORT: {
                        return PrimitiveObjectInspectorFactory.writableShortObjectInspector;
                    }
                    case INT: {
                        return PrimitiveObjectInspectorFactory.writableIntObjectInspector;
                    }
                    case LONG: {
                        return PrimitiveObjectInspectorFactory.writableLongObjectInspector;
                    }
                    case BINARY: {
                        return PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
                    }
                    case STRING: {
                        return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
                    }
                    case VARCHAR: {
                        VarcharTypeParams varcharParams = (VarcharTypeParams)ParameterizedPrimitiveTypeUtils.getTypeParamsFromTypeInfo(info);
                        if (varcharParams == null) {
                            throw new IllegalArgumentException("varchar type used without type params");
                        }
                        return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)info);
                    }
                    case TIMESTAMP: {
                        return PrimitiveObjectInspectorFactory.javaTimestampObjectInspector;
                    }
                    case DATE: {
                        return PrimitiveObjectInspectorFactory.javaDateObjectInspector;
                    }
                    case DECIMAL: {
                        return PrimitiveObjectInspectorFactory.javaHiveDecimalObjectInspector;
                    }
                }
                throw new IllegalArgumentException("Unknown primitive type " + (Object)((Object)((PrimitiveTypeInfo)info).getPrimitiveCategory()));
            }
            case STRUCT: {
                return new OrcStructInspector((StructTypeInfo)info);
            }
            case UNION: {
                return new OrcUnion.OrcUnionObjectInspector((UnionTypeInfo)info);
            }
            case MAP: {
                return new OrcMapObjectInspector((MapTypeInfo)info);
            }
            case LIST: {
                return new OrcListObjectInspector((ListTypeInfo)info);
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)info.getCategory()));
    }

    static ObjectInspector createObjectInspector(int columnId, List<OrcProto.Type> types) {
        OrcProto.Type type = types.get(columnId);
        switch (type.getKind()) {
            case FLOAT: {
                return PrimitiveObjectInspectorFactory.writableFloatObjectInspector;
            }
            case DOUBLE: {
                return PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
            }
            case BOOLEAN: {
                return PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
            }
            case BYTE: {
                return PrimitiveObjectInspectorFactory.writableByteObjectInspector;
            }
            case SHORT: {
                return PrimitiveObjectInspectorFactory.writableShortObjectInspector;
            }
            case INT: {
                return PrimitiveObjectInspectorFactory.writableIntObjectInspector;
            }
            case LONG: {
                return PrimitiveObjectInspectorFactory.writableLongObjectInspector;
            }
            case BINARY: {
                return PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
            }
            case STRING: {
                return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
            }
            case VARCHAR: {
                if (!type.hasMaximumLength()) {
                    throw new UnsupportedOperationException("Illegal use of varchar type without length in ORC type definition.");
                }
                VarcharTypeParams varcharParams = new VarcharTypeParams();
                varcharParams.setLength(type.getMaximumLength());
                return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(PrimitiveObjectInspectorUtils.getTypeEntryFromTypeSpecs(PrimitiveObjectInspector.PrimitiveCategory.VARCHAR, varcharParams));
            }
            case TIMESTAMP: {
                return PrimitiveObjectInspectorFactory.javaTimestampObjectInspector;
            }
            case DATE: {
                return PrimitiveObjectInspectorFactory.javaDateObjectInspector;
            }
            case DECIMAL: {
                return PrimitiveObjectInspectorFactory.javaHiveDecimalObjectInspector;
            }
            case STRUCT: {
                return new OrcStructInspector(columnId, types);
            }
            case UNION: {
                return new OrcUnion.OrcUnionObjectInspector(columnId, types);
            }
            case MAP: {
                return new OrcMapObjectInspector(columnId, types);
            }
            case LIST: {
                return new OrcListObjectInspector(columnId, types);
            }
        }
        throw new UnsupportedOperationException("Unknown type " + (Object)((Object)type.getKind()));
    }

    static class OrcListObjectInspector
    implements ListObjectInspector,
    SettableListObjectInspector {
        private final ObjectInspector child;

        OrcListObjectInspector(ListTypeInfo info) {
            this.child = OrcStruct.createObjectInspector(info.getListElementTypeInfo());
        }

        OrcListObjectInspector(int columnId, List<OrcProto.Type> types) {
            OrcProto.Type type = types.get(columnId);
            this.child = OrcStruct.createObjectInspector(type.getSubtypes(0), types);
        }

        @Override
        public ObjectInspector getListElementObjectInspector() {
            return this.child;
        }

        @Override
        public Object getListElement(Object list, int i) {
            return ((List)list).get(i);
        }

        @Override
        public int getListLength(Object list) {
            return ((List)list).size();
        }

        @Override
        public List<?> getList(Object list) {
            return (List)list;
        }

        @Override
        public String getTypeName() {
            return "array<" + this.child.getTypeName() + ">";
        }

        @Override
        public ObjectInspector.Category getCategory() {
            return ObjectInspector.Category.LIST;
        }

        @Override
        public Object create(int size) {
            ArrayList<Object> result = new ArrayList<Object>(size);
            for (int i = 0; i < size; ++i) {
                result.add(null);
            }
            return result;
        }

        @Override
        public Object set(Object list, int index, Object element) {
            List l = (List)list;
            for (int i = l.size(); i < index + 1; ++i) {
                l.add(null);
            }
            l.set(index, element);
            return list;
        }

        @Override
        public Object resize(Object list, int newSize) {
            ((ArrayList)list).ensureCapacity(newSize);
            return list;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            if (o == this) {
                return true;
            }
            ObjectInspector other = ((OrcListObjectInspector)o).child;
            return other.equals(this.child);
        }
    }

    static class OrcMapObjectInspector
    implements MapObjectInspector,
    SettableMapObjectInspector {
        private final ObjectInspector key;
        private final ObjectInspector value;

        OrcMapObjectInspector(MapTypeInfo info) {
            this.key = OrcStruct.createObjectInspector(info.getMapKeyTypeInfo());
            this.value = OrcStruct.createObjectInspector(info.getMapValueTypeInfo());
        }

        OrcMapObjectInspector(int columnId, List<OrcProto.Type> types) {
            OrcProto.Type type = types.get(columnId);
            this.key = OrcStruct.createObjectInspector(type.getSubtypes(0), types);
            this.value = OrcStruct.createObjectInspector(type.getSubtypes(1), types);
        }

        @Override
        public ObjectInspector getMapKeyObjectInspector() {
            return this.key;
        }

        @Override
        public ObjectInspector getMapValueObjectInspector() {
            return this.value;
        }

        @Override
        public Object getMapValueElement(Object map, Object key) {
            return ((Map)map).get(key);
        }

        public Map<Object, Object> getMap(Object map) {
            return (Map)map;
        }

        @Override
        public int getMapSize(Object map) {
            return ((Map)map).size();
        }

        @Override
        public String getTypeName() {
            return "map<" + this.key.getTypeName() + "," + this.value.getTypeName() + ">";
        }

        @Override
        public ObjectInspector.Category getCategory() {
            return ObjectInspector.Category.MAP;
        }

        @Override
        public Object create() {
            return new HashMap();
        }

        @Override
        public Object put(Object map, Object key, Object value) {
            ((Map)map).put(key, value);
            return map;
        }

        @Override
        public Object remove(Object map, Object key) {
            ((Map)map).remove(key);
            return map;
        }

        @Override
        public Object clear(Object map) {
            ((Map)map).clear();
            return map;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            if (o == this) {
                return true;
            }
            OrcMapObjectInspector other = (OrcMapObjectInspector)o;
            return other.key.equals(this.key) && other.value.equals(this.value);
        }
    }

    static class OrcStructInspector
    extends SettableStructObjectInspector {
        private final List<StructField> fields;

        OrcStructInspector(StructTypeInfo info) {
            ArrayList<String> fieldNames = info.getAllStructFieldNames();
            ArrayList<TypeInfo> fieldTypes = info.getAllStructFieldTypeInfos();
            this.fields = new ArrayList<StructField>(fieldNames.size());
            for (int i = 0; i < fieldNames.size(); ++i) {
                this.fields.add(new Field(fieldNames.get(i), OrcStruct.createObjectInspector(fieldTypes.get(i)), i));
            }
        }

        OrcStructInspector(int columnId, List<OrcProto.Type> types) {
            OrcProto.Type type = types.get(columnId);
            int fieldCount = type.getSubtypesCount();
            this.fields = new ArrayList<StructField>(fieldCount);
            for (int i = 0; i < fieldCount; ++i) {
                int fieldType = type.getSubtypes(i);
                this.fields.add(new Field(type.getFieldNames(i), OrcStruct.createObjectInspector(fieldType, types), i));
            }
        }

        public List<StructField> getAllStructFieldRefs() {
            return this.fields;
        }

        @Override
        public StructField getStructFieldRef(String s) {
            for (StructField field : this.fields) {
                if (!field.getFieldName().equals(s)) continue;
                return field;
            }
            return null;
        }

        @Override
        public Object getStructFieldData(Object object, StructField field) {
            return ((OrcStruct)object).fields[((Field)field).offset];
        }

        @Override
        public List<Object> getStructFieldsDataAsList(Object object) {
            OrcStruct struct = (OrcStruct)object;
            ArrayList<Object> result = new ArrayList<Object>(struct.fields.length);
            for (Object child : struct.fields) {
                result.add(child);
            }
            return result;
        }

        @Override
        public String getTypeName() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("struct<");
            for (int i = 0; i < this.fields.size(); ++i) {
                StructField field = this.fields.get(i);
                if (i != 0) {
                    buffer.append(",");
                }
                buffer.append(field.getFieldName());
                buffer.append(":");
                buffer.append(field.getFieldObjectInspector().getTypeName());
            }
            buffer.append(">");
            return buffer.toString();
        }

        @Override
        public ObjectInspector.Category getCategory() {
            return ObjectInspector.Category.STRUCT;
        }

        @Override
        public Object create() {
            return new OrcStruct(0);
        }

        @Override
        public Object setStructFieldData(Object struct, StructField field, Object fieldValue) {
            OrcStruct orcStruct = (OrcStruct)struct;
            int offset = ((Field)field).offset;
            if (orcStruct.getNumFields() <= offset) {
                orcStruct.setNumFields(offset + 1);
            }
            orcStruct.setFieldValue(offset, fieldValue);
            return struct;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            if (o == this) {
                return true;
            }
            List<StructField> other = ((OrcStructInspector)o).fields;
            if (other.size() != this.fields.size()) {
                return false;
            }
            for (int i = 0; i < this.fields.size(); ++i) {
                StructField left = other.get(i);
                StructField right = this.fields.get(i);
                if (left.getFieldName().equals(right.getFieldName()) && left.getFieldObjectInspector().equals(right.getFieldObjectInspector())) continue;
                return false;
            }
            return true;
        }
    }

    static class Field
    implements StructField {
        private final String name;
        private final ObjectInspector inspector;
        private final int offset;

        Field(String name, ObjectInspector inspector, int offset) {
            this.name = name;
            this.inspector = inspector;
            this.offset = offset;
        }

        @Override
        public String getFieldName() {
            return this.name;
        }

        @Override
        public ObjectInspector getFieldObjectInspector() {
            return this.inspector;
        }

        @Override
        public String getFieldComment() {
            return null;
        }
    }
}

