/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.rcfile.stats;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.hive.ql.io.rcfile.merge.RCFileBlockMergeInputFormat;
import org.apache.hadoop.hive.ql.io.rcfile.stats.PartialScanMapper;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.mapred.Mapper;

@Explain(displayName="Partial Scan Statistics")
public class PartialScanWork
extends MapWork
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<String> inputPaths;
    private String aggKey;

    public PartialScanWork() {
    }

    public PartialScanWork(List<String> inputPaths) {
        this.inputPaths = inputPaths;
        PartitionDesc partDesc = new PartitionDesc();
        partDesc.setInputFileFormatClass(RCFileBlockMergeInputFormat.class);
        if (this.getPathToPartitionInfo() == null) {
            this.setPathToPartitionInfo(new LinkedHashMap<String, PartitionDesc>());
        }
        for (String path : this.inputPaths) {
            this.getPathToPartitionInfo().put(path, partDesc);
        }
    }

    public List<String> getInputPaths() {
        return this.inputPaths;
    }

    public void setInputPaths(List<String> inputPaths) {
        this.inputPaths = inputPaths;
    }

    public Class<? extends Mapper> getMapperClass() {
        return PartialScanMapper.class;
    }

    @Override
    public Long getMinSplitSize() {
        return null;
    }

    @Override
    public String getInputformat() {
        return CombineHiveInputFormat.class.getName();
    }

    @Override
    public boolean isGatheringStats() {
        return true;
    }

    @Explain(displayName="Stats Aggregation Key Prefix", normalExplain=false)
    public String getAggKey() {
        return this.aggKey;
    }

    public void setAggKey(String aggKey) {
        this.aggKey = aggKey;
    }
}

