/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.index.bitmap.BitmapIndexHandler;
import org.apache.hadoop.hive.ql.index.compact.CompactIndexHandler;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.IndexUtils;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.index.IndexWhereProcCtx;
import org.apache.hadoop.hive.ql.optimizer.physical.index.IndexWhereProcessor;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.MapredWork;

public class IndexWhereTaskDispatcher
implements Dispatcher {
    private final PhysicalContext physicalContext;

    public IndexWhereTaskDispatcher(PhysicalContext context) {
        this.physicalContext = context;
    }

    @Override
    public Object dispatch(Node nd, Stack<Node> stack, Object ... nodeOutputs) throws SemanticException {
        Task task = (Task)nd;
        ParseContext pctx = this.physicalContext.getParseContext();
        Map<Rule, NodeProcessor> operatorRules = this.createOperatorRules(pctx);
        if (operatorRules == null) {
            return null;
        }
        IndexWhereProcCtx indexWhereOptimizeCtx = new IndexWhereProcCtx(task, pctx);
        DefaultRuleDispatcher dispatcher = new DefaultRuleDispatcher(this.getDefaultProcessor(), operatorRules, indexWhereOptimizeCtx);
        DefaultGraphWalker ogw = new DefaultGraphWalker(dispatcher);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        if (!(task.getWork() instanceof MapredWork)) {
            return null;
        }
        topNodes.addAll(((MapredWork)task.getWork()).getMapWork().getAliasToWork().values());
        ogw.startWalking(topNodes, null);
        return null;
    }

    private Map<Rule, NodeProcessor> createOperatorRules(ParseContext pctx) throws SemanticException {
        LinkedHashMap<Rule, NodeProcessor> operatorRules = new LinkedHashMap<Rule, NodeProcessor>();
        ArrayList<String> supportedIndexes = new ArrayList<String>();
        supportedIndexes.add(CompactIndexHandler.class.getName());
        supportedIndexes.add(BitmapIndexHandler.class.getName());
        Collection<Table> topTables = pctx.getTopToTable().values();
        HashMap<Table, List<Index>> indexes = new HashMap<Table, List<Index>>();
        for (Table tbl : topTables) {
            List<Index> tblIndexes = IndexUtils.getIndexes(tbl, supportedIndexes);
            if (tblIndexes.size() <= 0) continue;
            indexes.put(tbl, tblIndexes);
        }
        if (indexes.size() == 0) {
            return null;
        }
        operatorRules.put(new RuleRegExp("RULEWhere", TableScanOperator.getOperatorName() + "%"), new IndexWhereProcessor(indexes));
        return operatorRules;
    }

    private NodeProcessor getDefaultProcessor() {
        return new NodeProcessor(){

            @Override
            public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
                return null;
            }
        };
    }
}

