/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyStringObjectInspector;
import org.apache.hadoop.io.Text;

public class LazyString
extends LazyPrimitive<LazyStringObjectInspector, Text> {
    public LazyString(LazyStringObjectInspector oi) {
        super(oi);
        this.data = new Text();
    }

    public LazyString(LazyString copy) {
        super(copy);
        this.data = new Text((Text)copy.data);
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        if (((LazyStringObjectInspector)this.oi).isEscaped()) {
            byte escapeChar = ((LazyStringObjectInspector)this.oi).getEscapeChar();
            byte[] inputBytes = bytes.getData();
            int outputLength = 0;
            for (int i = 0; i < length; ++i) {
                if (inputBytes[start + i] != escapeChar) {
                    ++outputLength;
                    continue;
                }
                ++outputLength;
                ++i;
            }
            ((Text)this.data).set(bytes.getData(), start, outputLength);
            if (outputLength < length) {
                int k = 0;
                byte[] outputBytes = ((Text)this.data).getBytes();
                for (int i = 0; i < length; ++i) {
                    byte b = inputBytes[start + i];
                    outputBytes[k++] = b != escapeChar || i == length - 1 ? b : inputBytes[start + ++i];
                }
                assert (k == outputLength);
            }
        } else {
            ((Text)this.data).set(bytes.getData(), start, length);
        }
    }
}

