/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazybinary;

import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryPrimitive;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeParams;
import org.apache.hadoop.io.Text;

public class LazyBinaryHiveVarchar
extends LazyBinaryPrimitive<WritableHiveVarcharObjectInspector, HiveVarcharWritable> {
    protected int maxLength = -1;

    LazyBinaryHiveVarchar(WritableHiveVarcharObjectInspector oi) {
        super(oi);
        VarcharTypeParams typeParams = (VarcharTypeParams)oi.getTypeParams();
        if (typeParams == null) {
            throw new RuntimeException("varchar type used without type params");
        }
        this.maxLength = typeParams.length;
        this.data = new HiveVarcharWritable();
    }

    LazyBinaryHiveVarchar(LazyBinaryHiveVarchar copy) {
        super(copy);
        this.maxLength = copy.maxLength;
        this.data = new HiveVarcharWritable((HiveVarcharWritable)copy.data);
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        Text textValue = ((HiveVarcharWritable)this.data).getTextValue();
        textValue.set(bytes.getData(), start, length);
        ((HiveVarcharWritable)this.data).enforceMaxLength(this.maxLength);
    }
}

